namespace IrrlichtNetSwig
{
    public partial class arrayTexture
    {
        public ITexture this[uint index]
        {
            get
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                return getValue(index);
            }
            set
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                setValue(index, value);
            }
        }
        public void set_pointer(ITexture[] pointer)
        {
            set_pointer((arrayTexture)pointer, (uint)pointer.Length);
        }
        public static implicit operator arrayTexture(ITexture[] other)
        {
            var arr = new arrayTexture((uint)other.Length);
            for (uint i = 0; i < other.Length; i++)
            {
                arr.push_back(other[i]);
            }
            return arr;
        }
        public ITexture[] ToArray()
        {
            var arr = new ITexture[size()];
            for (uint i = 0; i < size(); i++)
            {
                arr[i] = this.getValue(i);
            }
            return arr;
        }
    }
}