%module(directors="1") "IrrlichtNet"
#pragma SWIG nowarn=312
#pragma SWIG nowarn=516
%warnfilter(312) irr::scene::quake3::IQ3Shader;
%warnfilter(312) irr::IEventReceiver;
%warnfilter(312) irr::core::irrList;
%warnfilter(312) irr::core::irrMap;
%warnfilter(312) irr::scene::ISkinnedMesh;
%warnfilter(312) irr::video::SExposedVideoData;

%{
#include <Windows.h>
#include "Irrlicht.h"
#include "..\My.h"
#include "..\MySkinnedMesh.h"
#include "..\ISceneNode_ForInheritance.h"
#include "..\ConstStringArray.h"
#include "..\StaticStringArray.h"
#include "..\IFileReadCallBack_ForInheritance.h"
#include "..\IFileSystem_ForInheritance.h"
#include "..\IReadFile_ForInheritance.h"
#include "..\IWriteFile_ForInheritance.h"

using namespace irr;
using namespace core;
using namespace video;
using namespace gui;
using namespace scene;
%}

%feature("director") irr::IEventReceiver;
%feature("director") ISceneNode_ForInheritance;
%feature("director") irr::video::IShaderConstantSetCallBack;
%feature("director") irr::scene::IMeshLoader;
%feature("director") irr::scene::ISceneNodeAnimator;

%include "wchar.i"
%include "arrays_csharp.i"
%include "carrays.i"
%include "typemaps.i"

//%rename(IrrString) string;
%rename(IrrStringc) irr::core::string<char>;
%rename(IrrStringw) irr::core::string<wchar_t>;
%rename(Lock) lock;
%rename(equalTo) operator==;
%rename(notEqualTo) operator!=;
%rename(lessThan) operator<;
%rename(lessEqual) operator<=;
%rename(graterThan) operator>;
%rename(graterEqual) operator>=;
%rename(getItem) operator[];
%rename(add) operator+;
%rename(sub) operator-;
%rename(mul) operator*;
%rename(div) operator/;
%ignore operator=;
%ignore operator();
%ignore operator+=;
%ignore operator-=;
%ignore operator*=;
%ignore operator/=;
%ignore irr::core::array::operator==;
%ignore irr::core::array::operator!=;
%ignore irr::core::array::operator<=;
%ignore irr::core::array::operator>=;
%ignore irr::core::array::operator<;
%ignore irr::core::array::operator>;
//%ignore irr::core::array::sort;
//%ignore irr::core::array::binary_search;
//%ignore irr::core::array::binary_search_const;
//%ignore irr::core::array::linear_search;
%ignore irr::core::array::linear_search;
%ignore irr::core::array::linear_reverse_search;
%ignore irr::core::array::erase;



%ignore irr::core::array<irr::scene::quake3::SVariable>::sort;
%ignore irr::core::array<irr::scene::quake3::SVariable>::binary_search;
%ignore irr::core::array<irr::scene::quake3::SVariable>::binary_search_const;
%ignore irr::core::array<irr::scene::quake3::SVarGroup>::sort;
%ignore irr::core::array<irr::scene::quake3::SVarGroup>::binary_search;
%ignore irr::core::array<irr::scene::quake3::SVarGroup>::binary_search_const;
%ignore irr::core::array<irr::scene::SMD3Vertex>::sort;
%ignore irr::core::array<irr::scene::SMD3Vertex>::binary_search;
%ignore irr::core::array<irr::scene::SMD3Vertex>::binary_search_const;
%ignore irr::core::array<irr::scene::SMD3TexCoord>::sort;
%ignore irr::core::array<irr::scene::SMD3TexCoord>::binary_search;
%ignore irr::core::array<irr::scene::SMD3TexCoord>::binary_search_const;
%ignore irr::core::array<irr::scene::SMD3QuaterionTag>::sort;
%ignore irr::core::array<irr::scene::SMD3QuaterionTag>::binary_search;
%ignore irr::core::array<irr::scene::SMD3QuaterionTag>::binary_search_const;
%ignore irr::core::array<irr::gui::SGUISpriteFrame>::sort;
%ignore irr::core::array<irr::gui::SGUISpriteFrame>::binary_search;
%ignore irr::core::array<irr::gui::SGUISpriteFrame>::binary_search_const;
%ignore irr::core::array<MyIrrlicht::SPositionKey>::sort;
%ignore irr::core::array<MyIrrlicht::SPositionKey>::binary_search;
%ignore irr::core::array<MyIrrlicht::SPositionKey>::binary_search_const;
%ignore irr::core::array<MyIrrlicht::SJoint>::sort;
%ignore irr::core::array<MyIrrlicht::SJoint>::binary_search;
%ignore irr::core::array<MyIrrlicht::SJoint>::binary_search_const;
%ignore irr::core::array<MyIrrlicht::SRotationKey>::sort;
%ignore irr::core::array<MyIrrlicht::SRotationKey>::binary_search;
%ignore irr::core::array<MyIrrlicht::SRotationKey>::binary_search_const;
%ignore irr::core::array<MyIrrlicht::SWeight>::sort;
%ignore irr::core::array<MyIrrlicht::SWeight>::binary_search;
%ignore irr::core::array<MyIrrlicht::SWeight>::binary_search_const;
%ignore irr::core::array<MyIrrlicht::SScaleKey>::sort;
%ignore irr::core::array<MyIrrlicht::SScaleKey>::binary_search;
%ignore irr::core::array<MyIrrlicht::SScaleKey>::binary_search_const;
%ignore irr::core::array<irr::gui::SGUISprite>::sort;
%ignore irr::core::array<irr::gui::SGUISprite>::binary_search;
%ignore irr::core::array<irr::gui::SGUISprite>::binary_search_const;
%ignore irr::core::array<irr::SJoystickInfo>::sort;
%ignore irr::core::array<irr::SJoystickInfo>::binary_search;
%ignore irr::core::array<irr::SJoystickInfo>::binary_search_const;
%ignore irr::core::array<irr::scene::SSkinMeshBuffer>::sort;
%ignore irr::core::array<irr::scene::SSkinMeshBuffer>::binary_search;
%ignore irr::core::array<irr::scene::SSkinMeshBuffer>::binary_search_const;


%ignore irr::core::array::set_sorted;
%ignore irr::gui::IGUIElement::OnEvent;
%ignore irr::scene::ICameraSceneNode::OnEvent;
%ignore irr::scene::ISceneNodeAnimator::OnEvent;
%ignore irr::core::list::begin;
%ignore irr::core::list::end;
%ignore irr::core::list::getLast;
%ignore irr::core::list::insert_after;
%ignore irr::core::list::insert_before;
%ignore irr::core::list::erase;
%ignore irr::scene::quake3::irrEmptyStringc;
%ignore irr::scene::CIndexBuffer::Indices;
%ignore irr::scene::CVertexBuffer::CSpecificVertexList;
%ignore irr::scene::CVertexBuffer::IVertexList;
%ignore irr::scene::CVertexBuffer::Indices;
%ignore irr::scene::CIndexBuffer::IIndexList;
%ignore irr::scene::CIndexBuffer::CSpecificIndexList;
//lXg\̂̂ߖbp쐬
%ignore irr::scene::ISkinnedMesh::SWeight;
%ignore irr::scene::ISkinnedMesh::SPositionKey;
%ignore irr::scene::ISkinnedMesh::SScaleKey;
%ignore irr::scene::ISkinnedMesh::SRotationKey;
%ignore irr::scene::ISkinnedMesh::SJoint;
%ignore irr::scene::ISkinnedMesh::getAllJoints;
%ignore irr::scene::ISkinnedMesh::createJoint;
%ignore irr::scene::ISkinnedMesh::createWeight;
%ignore irr::scene::ISkinnedMesh::createPositionKey;
%ignore irr::scene::ISkinnedMesh::createScaleKey;
%ignore irr::scene::ISkinnedMesh::createRotationKey;
//ߖ
%ignore irr::io::createReadFile;
%ignore irr::io::createLimitReadFile;
%ignore irr::io::createMemoryReadFile;
%ignore irr::io::createWriteFile;


enum E_DEBUG_SCENE_TYPE
{
	//! No Debug Data ( Default )
	EDS_OFF = 0,

	//! Show Bounding Boxes of SceneNode
	EDS_BBOX = 1,

	//! Show Vertex Normals
	EDS_NORMALS = 2,

	//! Shows Skeleton/Tags
	EDS_SKELETON = 4,

	//! Overlays Mesh Wireframe
	EDS_MESH_WIRE_OVERLAY = 8,

	//! Temporary use transparency Material Type
	EDS_HALF_TRANSPARENCY = 16,

	//! Show Bounding Boxes of all MeshBuffers
	EDS_BBOX_BUFFERS = 32,

	//! EDS_BBOX | EDS_BBOX_BUFFERS
	EDS_BBOX_ALL = EDS_BBOX | EDS_BBOX_BUFFERS,

	//! Show all debug infos
	EDS_FULL = 0x7fffffff
};


//signed int𒴂lŏĂenum𖳌
%ignore E_DEBUG_SCENE_TYPE;


%typemap(csclassmodifiers) SWIGTYPE, SWIGTYPE *, SWIGTYPE &, SWIGTYPE [], SWIGTYPE (CLASS::*) "public partial class"


//SWIGŐϊłȂenum̏Ē`
#define CREATEID(c0,c1,c2,c3) ((c3 * 256 + c2) * 256 +c1)*256 + c0

enum EMESH_WRITER_TYPE
{
	//! Irrlicht Native mesh writer, for static .irrmesh files.
	EMWT_IRR_MESH     = CREATEID(0x69, 0x72, 0x72, 0x6D), //'i', 'r', 'r', 'm'

	//! COLLADA mesh writer for .dae and .xml files
	EMWT_COLLADA      = CREATEID(0x63, 0x6F, 0x6C, 0x6c), //'c', 'o', 'l' 'l'

	//! STL mesh writer for .stl files
	EMWT_STL          = CREATEID(0x73, 0x74, 0x6C, 0),    //'s', 't', 'l', 0

	//! OBJ mesh writer for .obj files
	EMWT_OBJ          = CREATEID(0x6F, 0x62, 0x6A, 0)     //'o', 'b', 'j', 0
};

enum ESCENE_NODE_TYPE
{
	//! simple cube scene node
	ESNT_CUBE           = CREATEID(0x63,0x75,0x62,0x65),  // 'c','u','b','e'

	//! Sphere scene node
	ESNT_SPHERE         = CREATEID(0x73,0x70,0x68,0x72),  // 's','p','h','r'

	//! Text Scene Node
	ESNT_TEXT           = CREATEID(0x74,0x65,0x78,0x74),  // 't','e','x','t'

	//! Water Surface Scene Node
	ESNT_WATER_SURFACE  = CREATEID(0x77,0x61,0x74,0x72),  // 'w','a','t','r'

	//! Terrain Scene Node
	ESNT_TERRAIN        = CREATEID(0x74,0x65,0x72,0x72),  // 't','e','r','r'

	//! Sky Box Scene Node
	ESNT_SKY_BOX        = CREATEID(0x73,0x6B,0x79,0x5F),  // 's','k','y','_'

	//! Shadow Volume Scene Node
	ESNT_SHADOW_VOLUME  = CREATEID(0x73,0x68,0x64,0x77),  // 's','h','d','w'

	//! OctTree Scene Node
	ESNT_OCT_TREE       = CREATEID(0x6F,0x63,0x74,0x74),  // 'o','c','t','t'

	//! Mesh Scene Node
	ESNT_MESH           = CREATEID(0x6D,0x65,0x73,0x68),  // 'm','e','s','h'

	//! Light Scene Node
	ESNT_LIGHT          = CREATEID(0x6C,0x67,0x68,0x74),  // 'l','g','h','t'

	//! Empty Scene Node
	ESNT_EMPTY          = CREATEID(0x65,0x6D,0x74,0x79),  // 'e','m','t','y'

	//! Dummy Transformation Scene Node
	ESNT_DUMMY_TRANSFORMATION = CREATEID(0x64,0x6D,0x6D,0x79),  // 'd','m','m','y'

	//! Camera Scene Node
	ESNT_CAMERA         = CREATEID(0x63,0x61,0x6D,0x5F),  // 'c','a','m','_'

	//! Billboard Scene Node
	ESNT_BILLBOARD      = CREATEID(0x62,0x69,0x6C,0x6C),  // 'b','i','l','l'

	//! Animated Mesh Scene Node
	ESNT_ANIMATED_MESH  = CREATEID(0x61,0x6D,0x73,0x68),  // 'a','m','s','h'

	//! Particle System Scene Node
	ESNT_PARTICLE_SYSTEM = CREATEID(0x70,0x74,0x63,0x6C),  // 'p','t','c','l'

	//! Quake3 Model Scene Node ( has tag to link to )
	ESNT_MD3_SCENE_NODE  = CREATEID(0x6D,0x64,0x33,0x5F),  // 'm','d','3','_'

	//! Maya Camera Scene Node
	//! Legacy, for loading version <= 1.4.x .irr files
	ESNT_CAMERA_MAYA    = CREATEID(0x63,0x61,0x6D,0x6D),  // 'c','a','m','M'

	//! First Person Shooter Camera
	//! Legacy, for loading version <= 1.4.x .irr files
	ESNT_CAMERA_FPS     = CREATEID(0x63,0x61,0x6D,0x46),  // 'c','a','m','F'

	//! Unknown scene node
	ESNT_UNKNOWN        = CREATEID(0x75,0x6E,0x6B,0x6E),  // 'u','n','k','n'

	//! Will match with any scene node when checking types
	ESNT_ANY            = CREATEID(0x61,0x6E,0x79,0x5F)  // 'a','n','y','_'
};
enum E_TRANSFORMATION_STATE_3
{
	ETS_VIEW_PROJECTION_3 = 2 + 1,   //video::ETS_PROJECTION + 1
	ETS_VIEW_MODEL_INVERSE_3,
	ETS_CURRENT_3,
	ETS_COUNT_3
};

//폜IReferenceCounted̎qNXȂdropOwndrop()Ăяo悤ɏ㏑
%typemap(csdestruct, methodname="Dispose", methodmodifiers="public") SWIGTYPE {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        this.DropOwnIfNeed();
        if (IsNeedDelete())
        {
            $imcall;
        }
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
    }
  }

%typemap(csdestruct_derived, methodname="Dispose", methodmodifiers="public") SWIGTYPE {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        this.DropOwnIfNeed();
        if (IsNeedDelete())
        {
            $imcall;
        }
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }
%typemap(cscode) SWIGTYPE, SWIGTYPE *, SWIGTYPE &, SWIGTYPE [], SWIGTYPE (CLASS::*) 
%{
    void DropOwnIfNeed(){}
    bool IsNeedDelete(){return true;}
%}

%typemap(cscode) irr::gui::ICursorControl "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIElementFactory "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIEnvironment "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIFont "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIFontBitmap "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUISpriteBank "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::ILogger "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IAttributeExchangingObject "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIElement"void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIButton "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUICheckBox "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIColorSelectDialog "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIComboBox "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIContextMenu "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIEditBox "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIFileOpenDialog "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIImage "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIInOutFader "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIListBox "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIMeshViewer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIScrollBar "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUISpinBox "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIStaticText "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUITab "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUITabControl "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUITable "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIToolBar "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUIWindow "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::gui::IGUISkin "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleAffector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleAttractionAffector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleFadeOutAffector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleGravityAffector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleRotationAffector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleAnimatedMeshSceneNodeEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleBoxEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleCylinderEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleMeshEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleRingEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleSphereEmitter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IAnimatedMeshSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IBillboardSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IBillboardTextSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IBoneSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ICameraSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IDummyTransformationSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ILightSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IParticleSystemSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IShadowVolumeSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ITerrainSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ITextSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IVolumeLightSceneNode "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeAnimator "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeAnimatorCameraFPS "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeAnimatorCameraMaya "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeAnimatorCollisionResponse "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IAttributes "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IFileList "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IFileSystem "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IReadFile "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IWriteFile "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::io::IXMLWriter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::IOSOperator "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::IrrlichtDevice "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::ITimer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IAnimationEndCallBack "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
//%typemap(cscode) irr::scene::IIndexBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
//%typemap(cscode) irr::scene::CIndexBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IAnimatedMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IAnimatedMeshMD2 "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IAnimatedMeshMD3 "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IQ3LevelMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISkinnedMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SAnimatedMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SMesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::CMeshBuffer< T > "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IDynamicMeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::CDynamicMeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SSharedMeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SSkinMeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshCache "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshLoader "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshManipulator "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMeshWriter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneCollisionManager "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneManager "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeAnimatorFactory "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ISceneNodeFactory "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::ITriangleSelector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IMetaTriangleSelector "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::IVertexBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::CVertexBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::quake3::IShaderManager "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::quake3::SVarGroupList "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SMD3Mesh "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SMD3MeshBuffer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::scene::SMD3QuaterionTagList "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IImage "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IImageLoader "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IImageWriter "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IMaterialRenderer "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IShaderConstantSetCallBack "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::ITexture "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IVideoDriver "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"
%typemap(cscode) irr::video::IVideoModeList "void DropOwnIfNeed(){this.dropOwn();} bool IsNeedDelete(){return false;}"

//%ignore irr::scene::quake3::SModifierFunction;
%ignore EMESH_WRITER_TYPE;
%ignore ESCENE_NODE_TYPE;
%ignore E_TRANSFORMATION_STATE_3;
%ignore irr::SEvent::SGUIEvent;
%ignore irr::SEvent::SMouseInput;
%ignore irr::SEvent::SKeyInput;
%ignore irr::SEvent::SJoystickEvent;
%ignore irr::SEvent::SLogEvent;
%ignore irr::SEvent::SUserEvent;
%ignore Irrlicht::SJoystickEvent::Axis;

%define EXTEND_CAST(fromType, toType)
%extend toType {
    static toType *cast(fromType *original) {
        return (toType *)(original);
    }
};
%enddef

EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIButton );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUICheckBox );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIColorSelectDialog );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIComboBox );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIContextMenu );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIEditBox );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIFileOpenDialog );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIImage );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIInOutFader );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIListBox );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIMeshViewer );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIScrollBar );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUISpinBox );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIStaticText );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUITab );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUITabControl );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUITable );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIToolBar );
EXTEND_CAST(irr::gui::IGUIElement, irr::gui::IGUIWindow );
EXTEND_CAST(irr::scene::ISceneNodeAnimator , irr::scene::ISceneNodeAnimatorCameraFPS );
EXTEND_CAST(irr::scene::ISceneNodeAnimator , irr::scene::ISceneNodeAnimatorCameraMaya );
EXTEND_CAST(irr::scene::ISceneNodeAnimator , irr::scene::ISceneNodeAnimatorCollisionResponse );
EXTEND_CAST(irr::gui::IGUIFont , irr::gui::IGUIFontBitmap );
EXTEND_CAST(irr::scene::IParticleAffector , irr::scene::IParticleAttractionAffector );
EXTEND_CAST(irr::scene::IParticleAffector , irr::scene::IParticleFadeOutAffector );
EXTEND_CAST(irr::scene::IParticleAffector , irr::scene::IParticleGravityAffector );
EXTEND_CAST(irr::scene::IParticleAffector , irr::scene::IParticleRotationAffector );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleAnimatedMeshSceneNodeEmitter );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleBoxEmitter );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleCylinderEmitter );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleMeshEmitter );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleRingEmitter );
EXTEND_CAST(irr::scene::IParticleEmitter , irr::scene::IParticleSphereEmitter );
EXTEND_CAST(irr::scene::ISceneNode , irr::scene::IAnimatedMeshSceneNode );
EXTEND_CAST(irr::scene::ISceneNode , irr::scene::IBillboardSceneNode );
EXTEND_CAST(irr::scene::ISceneNode , irr::scene::IBillboardTextSceneNode );
EXTEND_CAST(irr::scene::IBillboardSceneNode, irr::scene::IBillboardTextSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IBoneSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::ICameraSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IDummyTransformationSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::ILightSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IMeshSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IParticleSystemSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IShadowVolumeSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::ITerrainSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::ITextSceneNode );
EXTEND_CAST(irr::scene::ISceneNode ,  irr::scene::IVolumeLightSceneNode );
EXTEND_CAST(irr::scene::IIndexBuffer , irr::scene::CIndexBuffer );
EXTEND_CAST(irr::scene::IMesh , irr::scene::IAnimatedMesh );
EXTEND_CAST(irr::scene::IMesh , irr::scene::IAnimatedMeshMD2 );
EXTEND_CAST(irr::scene::IMesh , irr::scene::IAnimatedMeshMD3 );
EXTEND_CAST(irr::scene::IMesh , irr::scene::IQ3LevelMesh );
EXTEND_CAST(irr::scene::IMesh , irr::scene::ISkinnedMesh );
EXTEND_CAST(irr::scene::IMesh , irr::scene::SAnimatedMesh );
EXTEND_CAST(irr::scene::IMesh , irr::scene::SMesh );
EXTEND_CAST(irr::scene::IAnimatedMesh , irr::scene::IAnimatedMeshMD2 );
EXTEND_CAST(irr::scene::IAnimatedMesh , irr::scene::IAnimatedMeshMD3 );
EXTEND_CAST(irr::scene::IAnimatedMesh , irr::scene::IQ3LevelMesh );
EXTEND_CAST(irr::scene::IAnimatedMesh , irr::scene::ISkinnedMesh );
EXTEND_CAST(irr::scene::IAnimatedMesh , irr::scene::SAnimatedMesh );
EXTEND_CAST(irr::scene::IMeshBuffer , irr::scene::CMeshBuffer<T> );
EXTEND_CAST(irr::scene::IMeshBuffer , irr::scene::IDynamicMeshBuffer );
EXTEND_CAST(irr::scene::IMeshBuffer , irr::scene::CDynamicMeshBuffer );
EXTEND_CAST(irr::scene::IDynamicMeshBuffer , irr::scene::CDynamicMeshBuffer );
EXTEND_CAST(irr::scene::IMeshBuffer , irr::scene::SSharedMeshBuffer );
EXTEND_CAST(irr::scene::IMeshBuffer , irr::scene::SSkinMeshBuffer );
EXTEND_CAST(irr::scene::ITriangleSelector , irr::scene::IMetaTriangleSelector );
EXTEND_CAST(irr::scene::IVertexBuffer , irr::scene::CVertexBuffer );
EXTEND_CAST(IFileReadCallBack_ForInheritance , irr::io::IFileReadCallBack );
EXTEND_CAST(irr::io::IFileSystem_ForInheritance , irr::io::IFileSystem );
EXTEND_CAST(irr::io::IReadFile_ForInheritance , irr::io::IReadFile );
EXTEND_CAST(irr::io::IWriteFile_ForInheritance , irr::io::IWriteFile );


%define EXTEND_COPY_FROM(type)
%extend type {
    void CopyFrom(type *from) {
        *self = *from;
    }
};
%enddef

EXTEND_COPY_FROM(irr::video::SMaterial);

%define EXTEND_INDEXER(class, type)
%extend class{
    type getValue(unsigned int index)
    {
        return (*self)[index];
    }
    void setValue(unsigned int index, const type& val)
    {
        (*self)[index] = val;
    }
};
%enddef

EXTEND_INDEXER(irr::scene::IVertexBuffer, irr::video::S3DVertex);
EXTEND_INDEXER(irr::scene::CVertexBuffer, irr::video::S3DVertex);
EXTEND_INDEXER(irr::scene::SMD3QuaterionTagList, SMD3QuaterionTag);
EXTEND_INDEXER(irr::core::array<int>, int);
EXTEND_INDEXER(irr::core::array<rectInt>, rectInt);
EXTEND_INDEXER(irr::core::array<irr::core::stringc>, irr::core::stringc);
EXTEND_INDEXER(irr::core::array<irr::core::stringw>, irr::core::stringw);
EXTEND_INDEXER(irr::core::array<irr::core::vector3df>, irr::core::vector3df);
EXTEND_INDEXER(irr::core::array<irr::gui::SGUISpriteFrame>, irr::gui::SGUISpriteFrame);
EXTEND_INDEXER(irr::core::array<irr::gui::SGUISprite>, irr::gui::SGUISprite);
EXTEND_INDEXER(irr::core::array<irr::scene::quake3::SShader>, irr::scene::quake3::SShader);
EXTEND_INDEXER(irr::core::array<irr::scene::quake3::SVarGroup>, irr::scene::quake3::SVarGroup);
EXTEND_INDEXER(irr::core::array<irr::scene::quake3::SVariable>, irr::scene::quake3::SVariable);
EXTEND_INDEXER(irr::core::array<irr::scene::SMD3QuaterionTag>, irr::scene::SMD3QuaterionTag);
EXTEND_INDEXER(irr::core::array<irr::scene::SMD3TexCoord>, irr::scene::SMD3TexCoord);
EXTEND_INDEXER(irr::core::array<irr::scene::SMD3Vertex>, irr::scene::SMD3Vertex);
EXTEND_INDEXER(irr::core::array<irr::SJoystickInfo>, irr::SJoystickInfo);
EXTEND_INDEXER(irr::core::array<irr::video::S3DVertex2TCoords>, irr::video::S3DVertex2TCoords);
EXTEND_INDEXER(irr::core::array<irr::video::S3DVertexTangents>, irr::video::S3DVertexTangents);
EXTEND_INDEXER(irr::core::array<irr::video::S3DVertex>, irr::video::S3DVertex);
EXTEND_INDEXER(irr::core::array<unsigned char>, unsigned char);
EXTEND_INDEXER(irr::core::array<unsigned int>, unsigned int);
EXTEND_INDEXER(irr::core::array<unsigned short>, unsigned short);
EXTEND_INDEXER(irr::core::array<MyIrrlicht::SJoint>, MyIrrlicht::SJoint);
EXTEND_INDEXER(irr::core::array<MyIrrlicht::SRotationKey>, MyIrrlicht::SRotationKey);
EXTEND_INDEXER(irr::core::array<MyIrrlicht::SScaleKey>, MyIrrlicht::SScaleKey);
EXTEND_INDEXER(irr::core::array<MyIrrlicht::SPositionKey>, MyIrrlicht::SPositionKey);
EXTEND_INDEXER(irr::core::array<MyIrrlicht::SWeight>, MyIrrlicht::SWeight);
EXTEND_INDEXER(irr::core::CMatrix4<float>, float);

//CfNTƂɂsvȃ\bh폜
//%ignore irr::core::array<int>::getItem;
//%ignore irr::core::array<int>::getLast;
//%ignore irr::core::array<int>::pointer;
//%ignore irr::core::array<int>::const_pointer;
//%ignore irr::core::array<unsigned int>::getItem;
//%ignore irr::core::array<unsigned int>::getLast;
//%ignore irr::core::array<unsigned int>::pointer;
//%ignore irr::core::array<unsigned int>::const_pointer;
//%ignore irr::core::array<unsigned short>::getItem;
//%ignore irr::core::array<unsigned short>::getLast;
//%ignore irr::core::array<unsigned short>::pointer;
//%ignore irr::core::array<unsigned short>::const_pointer;
//%ignore irr::core::CMatrix4<float>::getItem;


//void*zɂ
%ignore irr::scene::IMeshBuffer::append(const void* const vertices, u32 numVertices, const u16* const indices, u32 numIndices);
%extend irr::scene::IMeshBuffer {
    void append(const irr::video::S3DVertex* const vertices, u32 numVertices, const u16* const indices, u32 numIndices)
    {
        self->append((void*)vertices, numVertices, indices, numIndices);
    }
    void append(const irr::video::S3DVertex2TCoords* const vertices, u32 numVertices, const u16* const indices, u32 numIndices)
    {
        self->append((void*)vertices, numVertices, indices, numIndices);
    }
    void append(const irr::video::S3DVertexTangents* const vertices, u32 numVertices, const u16* const indices, u32 numIndices)
    {
        self->append((void*)vertices, numVertices, indices, numIndices);
    }
};

%ignore irr::video::IVideoDriver::drawVertexPrimitiveList(const void* vertices, u32 vertexCount,
				const void* indexList, u32 primCount,
				E_VERTEX_TYPE vType, scene::E_PRIMITIVE_TYPE pType, E_INDEX_TYPE iType);
%extend irr::video::IVideoDriver {
    void drawVertexPrimitiveList(const irr::video::S3DVertex* vertices, u32 vertexCount,
								const int* indexList, u32 primCount,
								irr::video::E_VERTEX_TYPE vType, irr::scene::E_PRIMITIVE_TYPE pType, 
								irr::video::E_INDEX_TYPE iType)
    {
        self->drawVertexPrimitiveList((void*)vertices, vertexCount, (void*)indexList, primCount, 
        vType, pType, iType);
    }
    void drawVertexPrimitiveList(const irr::video::S3DVertex2TCoords* vertices, u32 vertexCount,
								const int* indexList, u32 primCount,
								irr::video::E_VERTEX_TYPE vType, irr::scene::E_PRIMITIVE_TYPE pType, 
								irr::video::E_INDEX_TYPE iType)
    {
        self->drawVertexPrimitiveList((void*)vertices, vertexCount, (void*)indexList, primCount, 
        vType, pType, iType);
    }
    void drawVertexPrimitiveList(const irr::video::S3DVertexTangents* vertices, u32 vertexCount,
								const int* indexList, u32 primCount,
								irr::video::E_VERTEX_TYPE vType, irr::scene::E_PRIMITIVE_TYPE pType, 
								irr::video::E_INDEX_TYPE iType)
    {
        self->drawVertexPrimitiveList((void*)vertices, vertexCount, (void*)indexList, primCount, 
        vType, pType, iType);
    }
};


%extend irr::core::array<irr::scene::IMesh*> {
    void set_pointer(irr::core::array<irr::scene::IMesh*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::scene::IMesh*>::set_pointer(irr::scene::IMesh** newPointer, u32 size);

%extend irr::core::array<irr::scene::IMeshBuffer*> {
    void set_pointer(irr::core::array<irr::scene::IMeshBuffer*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::scene::IMeshBuffer*>::set_pointer(irr::scene::IMeshBuffer** newPointer, u32 size);

%extend irr::core::array<irr::scene::ISceneNode*> {
    void set_pointer(irr::core::array<irr::scene::ISceneNode*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::scene::ISceneNode*>::set_pointer(irr::scene::ISceneNode** newPointer, u32 size);

%extend irr::core::array<irr::scene::SMD3MeshBuffer*> {
    void set_pointer(irr::core::array<irr::scene::SMD3MeshBuffer*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::scene::SMD3MeshBuffer*>::set_pointer(irr::scene::SMD3MeshBuffer** newPointer, u32 size);

%extend irr::core::array<irr::video::ITexture*> {
    void set_pointer(irr::core::array<irr::video::ITexture*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::video::ITexture*>::set_pointer(irr::video::ITexture** newPointer, u32 size);


%extend irr::core::array<irr::scene::SSkinMeshBuffer*> {
    void set_pointer(irr::core::array<irr::scene::SSkinMeshBuffer*>* newPointer, u32 size)
    {
        self->set_pointer(newPointer->pointer(), size);
    }
}
%ignore irr::core::array<irr::scene::SSkinMeshBuffer*>::set_pointer(irr::scene::SSkinMeshBuffer** newPointer, u32 size);



%extend irr::io::IAttributes {
    void addBinary(const c8* attributeName, unsigned char* data, s32 dataSizeInBytes)
    {
        self->addBinary(attributeName, data, dataSizeInBytes);
    }
}
%ignore irr::io::IAttributes::addBinary(const c8* attributeName, void* data, s32 dataSizeInBytes);



%extend irr::io::IAttributes {
    void setAttribute(const c8* attributeName, unsigned char* data, s32 dataSizeInBytes )
    {
        self->setAttribute(attributeName, data, dataSizeInBytes);
    }
}
%ignore irr::io::IAttributes::setAttribute(const c8* attributeName, void* data, s32 dataSizeInBytes );


%extend irr::io::IAttributes {
    void getAttributeAsBinaryData(const c8* attributeName, unsigned char* outData, s32 maxSizeInBytes)
    {
        self->setAttribute(attributeName, outData, maxSizeInBytes);
    }
}
%ignore irr::io::IAttributes::getAttributeAsBinaryData(const c8* attributeName, void* outData, s32 maxSizeInBytes);


%extend irr::io::IAttributes {
    void getAttributeAsBinaryData(s32 index, unsigned char* outData, s32 maxSizeInBytes)
    {
        self->getAttributeAsBinaryData(index, outData, maxSizeInBytes);
    }
}
%ignore irr::io::IAttributes::getAttributeAsBinaryData(s32 index, void* outData, s32 maxSizeInBytes);

%extend irr::video::IVideoDriver {
    void createImageFromData(ECOLOR_FORMAT format,
			const core::dimension2d<s32>& size, unsigned char *data,
			bool ownForeignMemory=false,
			bool deleteMemory = true)
    {
        self->createImageFromData(format, size, data, ownForeignMemory, deleteMemory);
    }
}
%ignore irr::video::IVideoDriver::createImageFromData(ECOLOR_FORMAT format,
			const core::dimension2d<s32>& size, void *data,
			bool ownForeignMemory=false,
			bool deleteMemory = true);


//%extend irr::io::IFileReadCallBack {
//    int read(unsigned char* buffer, int sizeToRead)
//    {
//        return self->read(buffer, sizeToRead);
//    }
//}
//%apply unsigned char OUTPUT[] {unsigned char* buffer}
//%ignore irr::io::IFileReadCallBack::read(void* buffer, int sizeToRead);

%apply int &INOUT { int& srcFact };
%apply int &INOUT { int& dstFact };
%apply int &INOUT { int& modulo };

void _unpack_texureBlendFunc ( int &srcFact, int &dstFact, int &modulo, const f32 param );
%{
void _unpack_texureBlendFunc ( int &srcFact, int &dstFact, int &modulo, const f32 param )
{
	E_BLEND_FACTOR srcFactOrg = (E_BLEND_FACTOR)srcFact;
	E_BLEND_FACTOR dstFactOrg = (E_BLEND_FACTOR)dstFact;
	E_MODULATE_FUNC moduloOrg = (E_MODULATE_FUNC)modulo;

	irr::video::unpack_texureBlendFunc ( srcFactOrg, dstFactOrg, moduloOrg, param );
	
	srcFact = (int)srcFactOrg;
	dstFact = (int)dstFactOrg;
	modulo = (int)moduloOrg;
}
%}
%ignore irr::video::unpack_texureBlendFunc ( E_BLEND_FACTOR &srcFact, E_BLEND_FACTOR &dstFact, E_MODULATE_FUNC &modulo, const f32 param );







%define EXTEND_POINTER_INDEXER(class, type)
%extend class{
    type getValue(unsigned int index)
    {
        return (*self)[index];
    }
    void setValue(unsigned int index, type val)
    {
        (*self)[index] = val;
    }
};
%enddef

EXTEND_POINTER_INDEXER(irr::core::array<irr::scene::IMeshBuffer*>, irr::scene::IMeshBuffer*);
EXTEND_POINTER_INDEXER(irr::core::array<irr::video::ITexture*>, irr::video::ITexture*);
EXTEND_POINTER_INDEXER(irr::core::array<irr::scene::SMD3MeshBuffer*>, irr::scene::SMD3MeshBuffer*);
EXTEND_POINTER_INDEXER(irr::core::array<irr::scene::IMesh*>, irr::scene::IMesh*);
EXTEND_POINTER_INDEXER(irr::core::array<irr::scene::ISceneNode*>, irr::scene::ISceneNode*);
EXTEND_POINTER_INDEXER(irr::core::array<irr::scene::SSkinMeshBuffer*>, irr::scene::SSkinMeshBuffer*);
//CfNTƂɂsvȃ\bh폜


//Irrlichtdrop()ŃCX^X폜悤
%extend irr::gui::ICursorControl {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIElementFactory {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIEnvironment {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIFont {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIFontBitmap {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUISpriteBank {bool dropOwn(){return self->drop();}};
%extend irr::ILogger {bool dropOwn(){return self->drop();}};
%extend irr::io::IAttributeExchangingObject {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIElement{bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIButton {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUICheckBox {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIColorSelectDialog {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIComboBox {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIContextMenu {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIEditBox {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIFileOpenDialog {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIImage {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIInOutFader {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIListBox {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIMeshViewer {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIScrollBar {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUISpinBox {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIStaticText {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUITab {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUITabControl {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUITable {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIToolBar {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUIWindow {bool dropOwn(){return self->drop();}};
%extend irr::gui::IGUISkin {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleAffector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleAttractionAffector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleFadeOutAffector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleGravityAffector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleRotationAffector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleAnimatedMeshSceneNodeEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleBoxEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleCylinderEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleMeshEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleRingEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleSphereEmitter {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IAnimatedMeshSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IBillboardSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IBillboardTextSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IBoneSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::ICameraSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IDummyTransformationSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::ILightSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IParticleSystemSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IShadowVolumeSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::ITerrainSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::ITextSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::IVolumeLightSceneNode {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeAnimator {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeAnimatorCameraFPS {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeAnimatorCameraMaya {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeAnimatorCollisionResponse {bool dropOwn(){return self->drop();}};
%extend irr::io::IAttributes {bool dropOwn(){return self->drop();}};
%extend irr::io::IFileList {bool dropOwn(){return self->drop();}};
%extend irr::io::IFileSystem {bool dropOwn(){return self->drop();}};
%extend irr::io::IReadFile {bool dropOwn(){return self->drop();}};
%extend irr::io::IWriteFile {bool dropOwn(){return self->drop();}};
%extend irr::io::IXMLWriter {bool dropOwn(){return self->drop();}};
%extend irr::IOSOperator {bool dropOwn(){return self->drop();}};
%extend irr::IrrlichtDevice {bool dropOwn(){return self->drop();}};
%extend irr::ITimer {bool dropOwn(){return self->drop();}};
%extend irr::scene::IAnimationEndCallBack {bool dropOwn(){return self->drop();}};
//%extend irr::scene::IIndexBuffer {bool dropOwn(){return self->drop();}};
//%extend irr::scene::CIndexBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::IAnimatedMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::IAnimatedMeshMD2 {bool dropOwn(){return self->drop();}};
%extend irr::scene::IAnimatedMeshMD3 {bool dropOwn(){return self->drop();}};
%extend irr::scene::IQ3LevelMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISkinnedMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::SAnimatedMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::SMesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::CMeshBuffer< T > {bool dropOwn(){return self->drop();}};
%extend irr::scene::IDynamicMeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::CDynamicMeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::SSharedMeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::SSkinMeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshCache {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshLoader {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshManipulator {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMeshWriter {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneCollisionManager {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneManager {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeAnimatorFactory {bool dropOwn(){return self->drop();}};
%extend irr::scene::ISceneNodeFactory {bool dropOwn(){return self->drop();}};
%extend irr::scene::ITriangleSelector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IMetaTriangleSelector {bool dropOwn(){return self->drop();}};
%extend irr::scene::IVertexBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::CVertexBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::quake3::IShaderManager {bool dropOwn(){return self->drop();}};
%extend irr::scene::quake3::SVarGroupList {bool dropOwn(){return self->drop();}};
%extend irr::scene::SMD3Mesh {bool dropOwn(){return self->drop();}};
%extend irr::scene::SMD3MeshBuffer {bool dropOwn(){return self->drop();}};
%extend irr::scene::SMD3QuaterionTagList {bool dropOwn(){return self->drop();}};
%extend irr::video::IImage {bool dropOwn(){return self->drop();}};
%extend irr::video::IImageLoader {bool dropOwn(){return self->drop();}};
%extend irr::video::IImageWriter {bool dropOwn(){return self->drop();}};
%extend irr::video::IMaterialRenderer {bool dropOwn(){return self->drop();}};
%extend irr::video::IShaderConstantSetCallBack {bool dropOwn(){return self->drop();}};
%extend irr::video::ITexture {bool dropOwn(){return self->drop();}};
%extend irr::video::IVideoDriver {bool dropOwn(){return self->drop();}};
%extend irr::video::IVideoModeList {bool dropOwn(){return self->drop();}};

%extend irr::scene::ICameraSceneNode
{
	bool OnEvent2(const SEvent& event)
	{
		return self->OnEvent(event);
	}
}

%extend irr::scene::IVertexBuffer
{
	irr::video::S3DVertex2TCoords* getDataS3DVertex2TCoords();
}
%{
irr::video::S3DVertex2TCoords* irr_scene_IVertexBuffer_getDataS3DVertex2TCoords(irr::scene::IVertexBuffer* self)
{
	return (irr::video::S3DVertex2TCoords*)self->getData();
}
%}


%extend irr::SIrrlichtCreationParameters
{
	int ButtonHandle;
}
%{
int irr_SIrrlichtCreationParameters_ButtonHandle_get(irr::SIrrlichtCreationParameters* self) {
    return (int)self->WindowId;
}
void irr_SIrrlichtCreationParameters_ButtonHandle_set(irr::SIrrlichtCreationParameters* self, int val) {
    self->WindowId = (void*)val;
}
%}



%extend irr::SEvent
{
	struct MyIrrlicht::SGUIEvent getGUIEvent();
	struct MyIrrlicht::SMouseInput getMouseInput();
	struct MyIrrlicht::SKeyInput getKeyInput();
	struct MyIrrlicht::SJoystickEvent getJoystickEvent();
	struct MyIrrlicht::SLogEvent getLogEvent();
	struct MyIrrlicht::SUserEvent getUserEvent();
}

%ignore MyIrrlicht::SJoint::SJoint;
%ignore MyIrrlicht::SPositionKey::SPositionKey;
%ignore MyIrrlicht::SRotationKey::SRotationKey;
%ignore MyIrrlicht::SScaleKey::SScaleKey;
%ignore MyIrrlicht::SWeight::SWeight;

%extend irr::scene::ISkinnedMesh
{
	core::array<MyIrrlicht::SJoint> getAllJoints2();
	MyIrrlicht::SJoint createJoint2(MyIrrlicht::SJoint *parent=0);
	MyIrrlicht::SWeight createWeight2(MyIrrlicht::SJoint *joint);
	MyIrrlicht::SPositionKey createPositionKey2(MyIrrlicht::SJoint *joint);
	MyIrrlicht::SScaleKey createScaleKey2(MyIrrlicht::SJoint *joint);
	MyIrrlicht::SRotationKey createRotationKey2(MyIrrlicht::SJoint *joint);
}

%{
MyIrrlicht::SGUIEvent irr_SEvent_getGUIEvent(SEvent* self)
{
	MyIrrlicht::SGUIEvent result(self);
	//result.Caller = self->GUIEvent.Caller;
	//result.Element = self->GUIEvent.Element;
	//result.EventType = self->GUIEvent.EventType;
	return result;
}

MyIrrlicht::SMouseInput irr_SEvent_getMouseInput(SEvent* self)
{
	MyIrrlicht::SMouseInput result(self);
	//result.Event = self->MouseInput.Event;
	//result.Wheel = self->MouseInput.Wheel;
	//result.X = self->MouseInput.X;
	//result.Y = self->MouseInput.Y;
	return result;
}

MyIrrlicht::SKeyInput irr_SEvent_getKeyInput(SEvent* self)
{
	MyIrrlicht::SKeyInput result(self);
	//result.Char = self->KeyInput.Char;
	//result.Control = self->KeyInput.Control;
	//result.Key = self->KeyInput.Key;
	//result.PressedDown = self->KeyInput.PressedDown;
	//result.Shift = self->KeyInput.Shift;
	return result;
}

MyIrrlicht::SJoystickEvent irr_SEvent_getJoystickEvent(SEvent* self)
{
	MyIrrlicht::SJoystickEvent result(self);
	//result.ButtonStates = self->JoystickEvent.ButtonStates;
	//result.Joystick = self->JoystickEvent.Joystick;
	//result.POV = self->JoystickEvent.POV;
	//result.Axis[0] = self->JoystickEvent.Axis[0];
	//result.Axis[1] = self->JoystickEvent.Axis[1];
	//result.Axis[2] = self->JoystickEvent.Axis[2];
	//result.Axis[3] = self->JoystickEvent.Axis[3];
	//result.Axis[4] = self->JoystickEvent.Axis[4];
	//result.Axis[5] = self->JoystickEvent.Axis[5];
	return result;
}

MyIrrlicht::SLogEvent irr_SEvent_getLogEvent(SEvent* self)
{
	MyIrrlicht::SLogEvent result(self);
	//result.Level = self->LogEvent.Level;
	//strncpy(result.Text, self->LogEvent.Text, 256);
	return result;
}

MyIrrlicht::SUserEvent irr_SEvent_getUserEvent(SEvent* self)
{
	MyIrrlicht::SUserEvent result(self);
	//result.UserData1 = self->UserEvent.UserData1;
	//result.UserData2 = self->UserEvent.UserData2;
	return result;
}
core::array<MyIrrlicht::SJoint> irr_scene_ISkinnedMesh_getAllJoints2(ISkinnedMesh* self)
{
	core::array<ISkinnedMesh::SJoint*>& originalList = self->getAllJoints();
	core::array<MyIrrlicht::SJoint> list;
	for(int i = 0; i < originalList.size(); i++)
	{
		list.push_back(MyIrrlicht::SJoint(originalList[i]));
	}
	return list;
}

MyIrrlicht::SJoint irr_scene_ISkinnedMesh_createJoint2(ISkinnedMesh* self, MyIrrlicht::SJoint *parent=0)
{
	ISkinnedMesh::SJoint* original =  self->createJoint(parent->origin);
	MyIrrlicht::SJoint result(original);
	return result;
}
MyIrrlicht::SWeight irr_scene_ISkinnedMesh_createWeight2(ISkinnedMesh* self, MyIrrlicht::SJoint *joint)
{
	ISkinnedMesh::SWeight* original =  self->createWeight(joint->origin);
	MyIrrlicht::SWeight result(original);
	return result;
}
MyIrrlicht::SPositionKey irr_scene_ISkinnedMesh_createPositionKey2(ISkinnedMesh* self, MyIrrlicht::SJoint *joint)
{
	ISkinnedMesh::SPositionKey* original =  self->createPositionKey(joint->origin);
	MyIrrlicht::SPositionKey result(original);
	return result;
}
MyIrrlicht::SScaleKey irr_scene_ISkinnedMesh_createScaleKey2(ISkinnedMesh* self, MyIrrlicht::SJoint *joint)
{
	ISkinnedMesh::SScaleKey* original =  self->createScaleKey(joint->origin);
	MyIrrlicht::SScaleKey result(original);
	return result;
}
MyIrrlicht::SRotationKey irr_scene_ISkinnedMesh_createRotationKey2(ISkinnedMesh* self, MyIrrlicht::SJoint *joint)
{
	ISkinnedMesh::SRotationKey* original =  self->createRotationKey(joint->origin);
	MyIrrlicht::SRotationKey result(original);
	return result;
}
%}

%apply unsigned short INPUT[] {unsigned short* indices}
%apply unsigned short INPUT[] {unsigned short* indexList}
%apply int OUTPUT[] {int* outBegin}
%apply int OUTPUT[] {int* outEnd}
%apply int OUTPUT[] {int* outFPS}
%apply int INPUT[] {int* newPointer}
%apply float INPUT[] {const float* floats}
%apply float INPUT[] {const float* data}
%apply float OUTPUT[] {float *out}
%apply float OUTPUT[] {float *matrix}
%apply float OUTPUT[] {float *array}
%apply unsigned int INPUT[] { unsigned int* newPointer}	//̈悪Ȃv`FbN
%apply unsigned short INPUT[] { unsigned short* newPointer}	//̈悪Ȃv`FbN
%apply unsigned char INPUT[] {unsigned char* newPointer}	//̈悪Ȃv`FbN
%apply unsigned char OUTPUT[] { unsigned char* dest}
%apply int INPUT[] { int* indexList}
%apply unsigned char INPUT[]{ unsigned char* data}
%apply unsigned char OUTPUT[] {unsigned char* outData}

//CSHARP_ARRAYS(irr::video::S3DVertex, S3DVertex)
//%apply irr::video::S3DVertex INPUT[] {const irr::video::S3DVertex* vertices}
//%array_functions(irr::video::S3DVertex, S3DVertexArray);


%array_class(irr::SKeyMap, SKeyMapArray);
%array_class(vector3df, vector3dfArray);
%array_class(irr::video::S3DVertex, S3DVertexArray);
%array_class(irr::video::S3DVertex2TCoords, S3DVertex2TCoordsArray);
%array_class(irr::video::S3DVertexTangents, S3DVertexTangentsArray);
%array_class(irr::core::triangle3df, triangle3dfArray);

//%array_class(float,floatArray);

//ref̈
%apply int &INOUT { int& outBegin };
%apply int &INOUT { int& outEnd };
%apply int &INOUT { int& outFPS };
%apply bool &INOUT { bool& outFalling };
%apply double &INOUT { double& outdistance };
%apply float &INOUT {float &angle};
%apply unsigned int *INOUT {unsigned int * MHz};
%apply unsigned int *INOUT {unsigned int * Total};
%apply unsigned int *INOUT {unsigned int * Avail};
%apply unsigned int &INOUT {unsigned int & pos};

%apply unsigned int &INOUT { unsigned int& state };
%apply unsigned int &INOUT { unsigned int& startPos };
%apply int &INOUT { int& outTriangleCount };

//߂lz̏ꍇ
%define RETURN_POINTER_TO_ARRAY(returnType, methodName, arrayCount)
//%apply float OUTPUT[] {returnType* methodName}
%typemap(csout, excode=SWIGEXCODE) returnType * methodName
{
    IntPtr cPtr = $imcall;
    returnType [] ret = new returnType [ arrayCount ];
    int size = Marshal.SizeOf( typeof(returnType ));
    for(int i = 0; i < ret.Length; i++)
    {
        ret[i] = ( returnType )Marshal.PtrToStructure((IntPtr)((int)cPtr + size * i), typeof( returnType ));
    }
    return ret;
}
%typemap(cstype) returnType * methodName "returnType[]"
%typemap(out) returnType * methodName %{ $result = ( returnType *)$1; %} 
%enddef

RETURN_POINTER_TO_ARRAY(float, irr::core::CMatrix4<float>::pointer, 16);

/*
%typemap(cstype, out="byte[]") void * data "byte[]"
%typemap(csin) void * data "$*csclassname.getCPtr($csinput)" 
*/
%typemap(out) float * %{ $result = (float *)$1; %} 

//%typemap(cstype, out="uint") unsigned int * MHz "ref uint"
//%typemap(cstype, out="uint") unsigned int * Total "ref uint"
//%typemap(cstype, out="uint") unsigned int * Avail "ref uint"
//%typemap(cstype, out="bool") bool& outFalling "ref bool"
//%typemap(csin,
//         pre="    CDate temp$csinput = new CDate($csinput.Year, $csinput.Month, $csinput.Day);",
//         post="      $csinput = new System.DateTime(temp$csinput.getYear(),"
//              " temp$csinput.getMonth(), temp$csinput.getDay(), 0, 0, 0);", 
//         cshin="ref $csinput"
//        ) CDate *
//         "$csclassname.getCPtr(temp$csinput)"

//%typemap(cstype) (int (*)(int,int)) "EventHandler"
//%typemap(csin) (int (*)(int,int)) "$&csclassname.getCPtr($csinput)"

//void*IntPtrɂ
%define VoidToIntPtr(MethodName)
%typemap(ctype) void * MethodName "void *"
%typemap(imtype) void * MethodName "IntPtr"
%typemap(cstype) void * MethodName "IntPtr"
%typemap(csout, excode=SWIGEXCODE) void * MethodName 
{
    IntPtr cPtr = $imcall;
    return cPtr;
}
%enddef
VoidToIntPtr(lock())
VoidToIntPtr(getAttributeAsUserPointer)
VoidToIntPtr(getCellData)


//ϐvpeBɕϊ
%typemap(csin) void* WindowId "$csinput"	//C#璆ԃbp֓nۂ̈
//C#Œԃbp󂯎ϐ
%typemap(csout, excode=SWIGEXCODE) void* WindowId
{
    $imcall;
}
%typemap(imtype) void * WindowId "IntPtr"
%typemap(cstype) void * WindowId "IntPtr"		//C#̈̌^
%typemap(ctype) void * WindowId "void *"		//C++̈̌^
%typemap(csvarin, excode=SWIGEXCODE2) void * WindowId
%{
    set {
        $imcall;
    }
%}
%typemap(csvarout, excode=SWIGEXCODE2) void * WindowId
%{
    get {
        return $imcall;$excode
    } 
%}
//

//void*IntPtrɕϊ
%typemap(csin) void* userPointer "$csinput"	//C#璆ԃbp֓nۂ̈
%typemap(cstype) void * userPointer "IntPtr"		//C#̈̌^
%typemap(ctype) void * userPointer "void *"			//C++̈̌^
%typemap(imtype) void * userPointer "IntPtr"		//ԃbp̌^


%typemap(csin) void* windowId "$csinput"	//C#璆ԃbp֓nۂ̈
%typemap(cstype) void * windowId "IntPtr"		//C#̈̌^
%typemap(ctype) void * windowId "void *"			//C++̈̌^
%typemap(imtype) void * windowId "IntPtr"		//ԃbp̌^


%typemap(csin) void* data "$csinput"	//C#璆ԃbp֓nۂ̈
%typemap(cstype) void * data "IntPtr"		//C#̈̌^
%typemap(ctype) void * data "void *"			//C++̈̌^
%typemap(imtype) void * data "IntPtr"		//ԃbp̌^


char ToAsciiFromKeyCode(unsigned int keyCode);

%{
BYTE _keystate[256];
char ToAsciiFromKeyCode(unsigned int keyCode)
{
	WORD keyResult;
    GetKeyboardState(_keystate);
	int result = ToAscii(keyCode, MapVirtualKey(keyCode, 0), _keystate, &keyResult,0);
	if(result)
	{
		keyResult = keyResult & 0x00ff;
	}
	else
	{
		keyResult = 0;
	}
	return (char)keyResult;
}
%}

%extend irr::scene::SMD3Header {
    char* _fileName;
}
%{
char* irr_scene_SMD3Header__fileName_get(irr::scene::SMD3Header* self) {
    return (char*)self->fileName;
}
void irr_scene_SMD3Header__fileName_set(irr::scene::SMD3Header* self, char* val) {
    strncpy_s(self->fileName, (char*)val, 68);
}
%}
%ignore irr::scene::SMD3Header::fileName;


%extend irr::io::IAttributes {
    void _addEnum(const c8* attributeName, s32 enumValue, ConstStringArray* enumerationLiterals)
    {
        self->addEnum(attributeName, enumValue, enumerationLiterals->GetPointer());
    }
    void _setAttribute(const c8* attributeName, const c8* enumValue, ConstStringArray* enumerationLiterals)
    {
    	self->setAttribute(attributeName, enumValue, enumerationLiterals->GetPointer());
    }
    void _setAttribute(s32 index, const c8* enumValue, ConstStringArray* enumerationLiterals)
    {
    	self->setAttribute(index, enumValue, enumerationLiterals->GetPointer());
    }
    int _getAttributeAsEnumeration(const c8* attributeName, ConstStringArray* enumerationLiteralsToUse)
    {
    	return self->getAttributeAsEnumeration(attributeName, enumerationLiteralsToUse->GetPointer());
    }
    int _getAttributeAsEnumeration(s32 index, ConstStringArray* enumerationLiteralsToUse)
    {
        return self->getAttributeAsEnumeration(index, enumerationLiteralsToUse->GetPointer());
    }
}
%ignore irr::io::IAttributes::addEnum(const c8* attributeName, const c8* enumValue, const c8* const* enumerationLiterals);
%ignore irr::io::IAttributes::addEnum(const c8* attributeName, s32 enumValue, const c8* const* enumerationLiterals);
%ignore irr::io::IAttributes::setAttribute(const c8* attributeName, const c8* enumValue, const c8* const* enumerationLiterals);
%ignore irr::io::IAttributes::setAttribute(s32 index, const c8* enumValue, const c8* const* enumerationLiterals);
%ignore irr::io::IAttributes::getAttributeAsEnumeration(const c8* attributeName, const c8* const* enumerationLiteralsToUse);
%ignore irr::io::IAttributes::getAttributeAsEnumeration(s32 index, const c8* const* enumerationLiteralsToUse); 


%define AddGetVerticesMethod(ClassName, MethodName1, MethodName2, MethodName3)
%extend ClassName {
	irr::core::array<irr::video::S3DVertex*> MethodName1()
	{
		irr::core::array<irr::video::S3DVertex*> arr;
		irr::video::S3DVertex* p = (irr::video::S3DVertex*)self->getVertices();
		for(unsigned int i = 0; i < self->getVertexCount(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
	irr::core::array<irr::video::S3DVertex2TCoords*> MethodName2()
	{
		irr::core::array<irr::video::S3DVertex2TCoords*> arr;
		irr::video::S3DVertex2TCoords* p = (irr::video::S3DVertex2TCoords*)self->getVertices();
		for(unsigned int i = 0; i < self->getVertexCount(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
	irr::core::array<irr::video::S3DVertexTangents*> MethodName3()
	{
		irr::core::array<irr::video::S3DVertexTangents*> arr;
		irr::video::S3DVertexTangents* p = (irr::video::S3DVertexTangents*)self->getVertices();
		for(unsigned int i = 0; i < self->getVertexCount(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
}
%enddef

AddGetVerticesMethod(irr::scene::IDynamicMeshBuffer, _getVerticesAsS3DVertex, _getVerticesAsS3DVertex2TCoords, _getVerticesAsS3DVertexTangents);
AddGetVerticesMethod(irr::scene::IMeshBuffer, _getVerticesAsS3DVertex, _getVerticesAsS3DVertex2TCoords, _getVerticesAsS3DVertexTangents);
AddGetVerticesMethod(irr::scene::SSharedMeshBuffer, _getVerticesAsS3DVertex, _getVerticesAsS3DVertex2TCoords, _getVerticesAsS3DVertexTangents);
AddGetVerticesMethod(irr::scene::SSkinMeshBuffer, _getVerticesAsS3DVertex, _getVerticesAsS3DVertex2TCoords, _getVerticesAsS3DVertexTangents);
%ignore irr::scene::IDynamicMeshBuffer::getVertices;
%ignore irr::scene::IMeshBuffer::getVertices;
%ignore irr::scene::SSharedMeshBuffer::getVertices;
%ignore irr::scene::SSkinMeshBuffer::getVertices; 


%extend irr::scene::IVertexBuffer {
	irr::core::array<irr::video::S3DVertex*> _getDataAsS3DVertex()
	{
		irr::core::array<irr::video::S3DVertex*> arr;
		irr::video::S3DVertex* p = (irr::video::S3DVertex*)self->getData();
		for(unsigned int i = 0; i < self->size(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
	irr::core::array<irr::video::S3DVertex2TCoords*> _getDataAsS3DVertex2TCoords()
	{
		irr::core::array<irr::video::S3DVertex2TCoords*> arr;
		irr::video::S3DVertex2TCoords* p = (irr::video::S3DVertex2TCoords*)self->getData();
		for(unsigned int i = 0; i < self->size(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
	irr::core::array<irr::video::S3DVertexTangents*> _getDataAsS3DVertexTangents()
	{
		irr::core::array<irr::video::S3DVertexTangents*> arr;
		irr::video::S3DVertexTangents* p = (irr::video::S3DVertexTangents*)self->getData();
		for(unsigned int i = 0; i < self->size(); i++)
		{
			arr.push_back(p);
			p++;
		}
		return arr;
	}
}
%ignore irr::scene::IVertexBuffer::getData();



%extend irr::scene::IIndexBuffer {
	irr::core::array<int> _getData()
	{
		irr::core::array<int> arr;
		int* p = (int*)self->getData();
		for(unsigned int i = 0; i < self->size(); i++)
		{
			arr.push_back(*p);
			p++;
		}
		return arr;
	}
	irr::core::array<int> _pointer()
	{
		irr::core::array<int> arr;
		int* p = (int*)self->pointer();
		for(unsigned int i = 0; i < self->size(); i++)
		{
			arr.push_back(*p);
			p++;
		}
		return arr;
	}
}
%ignore irr::scene::IIndexBuffer::getData();
%ignore irr::scene::IIndexBuffer::pointer();

%define AddGetIndicesMethod(ClassName)
%extend ClassName {
	irr::core::array<unsigned short> _getIndices()
	{
		irr::core::array<unsigned short> arr;
		unsigned short* p = (unsigned short*)self->getIndices();
		for(unsigned int i = 0; i < self->getIndexCount(); i++)
		{
			arr.push_back(*p);
			p++;
		}
		return arr;
	}
}
%enddef
AddGetIndicesMethod(irr::scene::IDynamicMeshBuffer);
AddGetIndicesMethod(irr::scene::IMeshBuffer);
AddGetIndicesMethod(irr::scene::SSharedMeshBuffer);
AddGetIndicesMethod(irr::scene::SSkinMeshBuffer);
%ignore irr::scene::IDynamicMeshBuffer::getIndices;	// arrayUShort
%ignore irr::scene::IMeshBuffer::getIndices;			// arrayUShort
%ignore irr::scene::SSharedMeshBuffer::getIndices;	// arrayUShort
%ignore irr::scene::SSkinMeshBuffer::getIndices;		// arrayUShort


%define AddIndexerMathod(ClassName, Method, Type, GetMethod, SetMethod, Count)
%extend ClassName {
	Type GetMethod(int index)
	{
		if(index < 0 || Count <= index)
		{
			return 0;
		}
		return self->Method[index];
	}
	void SetMethod(int index, Type value)
	{
		if(index < 0 || Count <= index)
		{
			return;
		}
		self->Method[index] = value;
	}
}
%enddef
AddIndexerMathod(irr::scene::SMD3Face, Index, int, _getIndex, _setIndex, 3);
AddIndexerMathod(irr::scene::SMD3Vertex, position, short, _getposition, _setposition, 3);
AddIndexerMathod(irr::scene::SMD3Vertex, normal, unsigned char, _getnormal, _setnormal, 2);
%ignore irr::scene::SMD3Face::Index;					// int[3]
%ignore irr::scene::SMD3Vertex::position;				// short[3]
%ignore irr::scene::SMD3Vertex::normal;					// unsigned char[2]

irr::io::IrrXMLReader* _createIrrXMLReader(int handle);
%{
#include<stdio.h>
#include<io.h>
#include<stdlib.h>
#include <fcntl.h>
irr::io::IrrXMLReader* _createIrrXMLReader(int handle)
{
	int CrtFileHandle;
	FILE *stream;

	if ( (CrtFileHandle=_open_osfhandle(handle,_O_RDONLY))==-1){
		printf(  "_open_osfhandle Failed");
		return NULL;
	}
	if( (stream = _fdopen( CrtFileHandle, "r" )) == NULL ) {
		printf(  "_fdopen Failed");
		return NULL;
	}
	return irr::io::createIrrXMLReader(stream);
}
%}
%ignore irr::io::createIrrXMLReader(FILE* file);


//pΉ
%feature("director") IFileReadCallBack_ForInheritance;
%ignore irr::io::IFileReadCallBack::read(void* buffer, int sizeToRead);
//%ignore irr::io::createIrrXMLReader(irr::io::IFileReadCallBack* callback);
//irr::io::IrrXMLReader* _createIrrXMLReader(IFileReadCallBack_ForInheritance* callback);
//%{
//irr::io::IrrXMLReader* _createIrrXMLReader(IFileReadCallBack_ForInheritance* callback)
//{
//	return createIrrXMLReader(callback);
//}
//%}

%feature("director") irr::io::IFileSystem_ForInheritance;
%ignore irr::io::IFileSystem::createMemoryReadFile(void* memory, s32 len, const c8* fileName, bool deleteMemoryWhenDropped=false);

%feature("director") irr::io::IReadFile_ForInheritance;
%ignore irr::io::IReadFile::read(void* buffer, u32 sizeToRead);

%feature("director") irr::io::IWriteFile_ForInheritance;
%ignore irr::io::IWriteFile::write(const void* buffer, u32 sizeToWrite);



//char*zϊ


%ignore irr::video::sBuiltInMaterialTypeNames;
%ignore irr::video::aTextureClampNames;
%ignore irr::video::sBuiltInVertexTypeNames;
%ignore irr::scene::AutomaticCullingNames;
%ignore irr::gui::GUIAlignmentNames;
%ignore irr::gui::GUIElementTypeNames;
%ignore irr::scene::BoneAnimationModeNames;
%ignore irr::video::VERTEX_SHADER_TYPE_NAMES;
%ignore irr::video::PIXEL_SHADER_TYPE_NAMES;
%ignore irr::gui::GUIButtonStateNames;
%ignore irr::gui::GUISkinTypeNames;
%ignore irr::gui::GUISkinColorNames;
%ignore irr::gui::GUISkinSizeNames;
%ignore irr::gui::GUISkinTextNames;
%ignore irr::gui::GUISkinIconNames;
%ignore irr::gui::GUISkinFontNames;
%ignore irr::gui::GUIColumnOrderingNames;
%ignore irr::gui::GUIOrderingModeNames;
%ignore irr::video::LightTypeNames;
%ignore irr::scene::ParticleAffectorTypeNames;
%ignore irr::scene::ParticleEmitterTypeNames;


%ignore ConstStringArray::ConstStringArray(char** list, int size);
%ignore ConstStringArray::ConstStringArray(const char* const* list);
%ignore ConstStringArray::ConstStringArray(char** list);
%ignore ConstStringArray::ConstStringArray(const char* const* list, int size);
%ignore ConstStringArray::GetPointer;

%include "IGUIEnvironment.i"




//gȂ\bhorgȂ\bh𖳌
%ignore irr::core::array<int>::const_pointer;
%ignore irr::core::array<int>::operator[];
%ignore irr::core::array<int>::getLast;
%ignore irr::core::array<int>::pointer;
%ignore irr::core::array<unsigned char>::const_pointer;
%ignore irr::core::array<unsigned char>::operator[];
%ignore irr::core::array<unsigned char>::getLast;
%ignore irr::core::array<unsigned char>::pointer;
%ignore irr::core::array<irr::scene::IMesh*>::const_pointer;
%ignore irr::core::array<irr::scene::IMesh*>::pointer;
%ignore irr::core::array<irr::scene::IMeshBuffer*>::const_pointer;
%ignore irr::core::array<irr::scene::IMeshBuffer*>::pointer;
%ignore irr::core::array<irr::scene::ISceneNode*>::const_pointer;
%ignore irr::core::array<irr::scene::ISceneNode*>::pointer;
%ignore irr::core::array<irr::scene::SSkinMeshBuffer*>::const_pointer;
%ignore irr::core::array<irr::scene::SSkinMeshBuffer*>::pointer;
%ignore irr::core::array<irr::scene::SMD3MeshBuffer*>::const_pointer;
%ignore irr::core::array<irr::scene::SMD3MeshBuffer*>::pointer;
%ignore irr::core::array<irr::video::ITexture*>::const_pointer;
%ignore irr::core::array<irr::video::ITexture*>::pointer;
%ignore irr::core::array<unsigned int>::const_pointer;
%ignore irr::core::array<unsigned int>::operator[];
%ignore irr::core::array<unsigned int>::getLast;
%ignore irr::core::array<unsigned int>::pointer;
%ignore irr::core::array<unsigned int>::Last;
%ignore irr::core::array<unsigned short>::const_pointer;
%ignore irr::core::array<unsigned short>::operator[];
%ignore irr::core::array<unsigned short>::getLast;
%ignore irr::core::array<unsigned short>::pointer;
%ignore irr::core::array<unsigned short>::Last;
%ignore irr::core::CMatrix4<float>::operator[];
%ignore irr::scene::IDynamicMeshBuffer::append;
%ignore irr::video::IImage::copyToScaling;
%ignore irr::io::IIrrXMLReader<unsigned long,irr::io::IXMLBase>;
%ignore irr::io::IIrrXMLReader<unsigned short,irr::io::IXMLBase>;
%ignore irr::io::createIrrXMLReaderUTF16;
%ignore irr::io::createIrrXMLReaderUTF32;
%ignore irr::core::fast_atof_move;
%ignore irr::core::fast_atof_table;
%ignore irr::scene::quake3::getAsStringList;
%ignore irr::scene::quake3::isEqual;
%ignore irr::core::strtof10;
%ignore irr::core::strtol10;
%ignore irr::core::string<char>::operator[];
%ignore irr::core::string<wchar_t>::operator[];
%ignore MyIrrlicht::SJoint::origin;
%ignore MyIrrlicht::SWeight::origin;
%ignore irr::scene::SSharedMeshBuffer::append;
%ignore irr::scene::SSkinMeshBuffer::append;

%ignore irr::core::array<irr::video::S3DVertex*>::pointer;
%ignore irr::core::array<irr::video::S3DVertex*>::const_pointer;
%ignore irr::core::array<irr::video::S3DVertex*>::set_pointer;
%ignore irr::core::array<irr::video::S3DVertex2TCoords*>::pointer;
%ignore irr::core::array<irr::video::S3DVertex2TCoords*>::const_pointer;
%ignore irr::core::array<irr::video::S3DVertex2TCoords*>::set_pointer;
%ignore irr::core::array<irr::video::S3DVertexTangents*>::pointer;
%ignore irr::core::array<irr::video::S3DVertexTangents*>::const_pointer;
%ignore irr::core::array<irr::video::S3DVertexTangents*>::set_pointer;


%include "IrrCompileConfig.h"
%include "irrTypes.h"
%include "irrMath.h"
%include "vector3d.h"
%include "plane3d.h"
%include "line3d.h"
%include "aabbox3d.h"
%include "IReferenceCounted.h"
%include "SColor.h"
%include "vector2d.h"
%include "dimension2d.h"
%include "position2d.h"
%include "rect.h"
%include "irrAllocator.h"
%include "irrString.h"
%include "matrix4.h"
%include "heapsort.h"
%include "irrArray.h"
%include "EMaterialTypes.h"
%include "EMaterialFlags.h"
%include "SMaterialLayer.h"
%include "SMaterial.h"
%include "S3DVertex.h"
%include "SVertexIndex.h"
%include "EHardwareBufferFlags.h"
%include "IMeshBuffer.h"
%include "IVertexBuffer.h"
%include "IIndexBuffer.h"
%include "IDynamicMeshBuffer.h"
%include "CVertexBuffer.h"
%include "CIndexBuffer.h"
%include "CDynamicMeshBuffer.h"
%include "CMeshBuffer.h"
%include "coreutil.h"
%include "ECullingTypes.h"
%include "EDebugSceneTypes.h"
%include "EDriverFeatures.h"
%include "EDriverTypes.h"
%include "EGUIAlignment.h"
%include "EGUIElementTypes.h"
%include "EMeshWriterEnums.h"
%include "EMessageBoxFlags.h"
%include "ESceneNodeAnimatorTypes.h"
%include "ESceneNodeTypes.h"
%include "ETerrainElements.h"
%include "fast_atof.h"
%include "IMesh.h"
%include "IAnimatedMesh.h"
%include "IAnimatedMeshMD2.h"
%include "irrXML.h"
%include "IXMLReader.h"
%include "IFileSystem.h"
%include "IImage.h"
%include "ITexture.h"
%include "triangle3d.h"
%include "IVideoDriver.h"
%include "IQ3Shader.h"
%include "quaternion.h"
%include "IAnimatedMeshMD3.h"
%include "IAttributeExchangingObject.h"
%include "ILogger.h"
%include "Keycodes.h"
%include "IEventReceiver.h"
%include "ISceneNodeAnimator.h"
%include "ITriangleSelector.h"
%include "irrList.h"
%include "line2d.h"
%include "IAttributes.h"
%include "ISceneNode.h"
%include "IBoneSceneNode.h"
%include "IAnimatedMeshSceneNode.h"
%include "IBillboardSceneNode.h"
%include "IBillboardTextSceneNode.h"
%include "ICameraSceneNode.h"
%include "ICursorControl.h"
%include "IDummyTransformationSceneNode.h"
%include "IFileList.h"
%include "IGPUProgrammingServices.h"
%include "IGUIElement.h"
%include "IGUIButton.h"
%include "IGUICheckBox.h"
%include "IGUIColorSelectDialog.h"
%include "IGUIComboBox.h"
%include "IGUIContextMenu.h"
%include "IGUIEditBox.h"
%include "IGUIElementFactory.h"
%include "IGUISkin.h"
%include "IGUIEnvironment.h"
%include "IGUIFileOpenDialog.h"
%include "IGUIFont.h"
%include "IGUIFontBitmap.h"
%include "IGUIImage.h"
%include "IGUIInOutFader.h"
%include "IGUIListBox.h"
%include "IGUIMeshViewer.h"
%include "IGUIScrollBar.h"
%include "IGUISpinBox.h"
%include "IGUISpriteBank.h"
%include "IGUIStaticText.h"
%include "IGUITabControl.h"
%include "IGUITable.h"
%include "IGUIToolbar.h"
%include "IGUIWindow.h"
%include "IImageLoader.h"
%include "IImageWriter.h"
%include "SLight.h"
%include "ILightSceneNode.h"
%include "IMaterialRenderer.h"
%include "IMaterialRendererServices.h"
%include "IMeshCache.h"
%include "IMeshLoader.h"
%include "IMeshManipulator.h"
%include "IMeshSceneNode.h"
%include "IMeshWriter.h"
%include "IMetaTriangleSelector.h"
%include "IOSOperator.h"
%include "SParticle.h"
%include "IParticleAffector.h"
%include "IParticleEmitter.h"
%include "IParticleAnimatedMeshSceneNodeEmitter.h"
%include "IParticleAttractionAffector.h"
%include "IParticleBoxEmitter.h"
%include "IParticleCylinderEmitter.h"
%include "IParticleFadeOutAffector.h"
%include "IParticleGravityAffector.h"
%include "IParticleMeshEmitter.h"
%include "IParticleRingEmitter.h"
%include "IParticleRotationAffector.h"
%include "IParticleSphereEmitter.h"
%include "IParticleSystemSceneNode.h"
%include "IQ3LevelMesh.h"
%include "IReadFile.h"
%include "IVideoModeList.h"
%include "ITimer.h"
%include "IrrlichtDevice.h"
%include "irrMap.h"
%include "ISceneCollisionManager.h"
%include "SceneParameters.h"
%include "ISceneManager.h"
%include "ISceneNodeAnimatorCameraFPS.h"
%include "ISceneNodeAnimatorCameraMaya.h"
%include "ISceneNodeAnimatorCollisionResponse.h"
%include "ISceneNodeAnimatorFactory.h"
%include "ISceneNodeFactory.h"
%include "ISceneUserDataSerializer.h"
%include "IShaderConstantSetCallBack.h"
%include "IShadowVolumeSceneNode.h"
%include "SSkinMeshBuffer.h"
%include "ISkinnedMesh.h"
%include "ITerrainSceneNode.h"
%include "ITextSceneNode.h"
%include "IVolumeLightSceneNode.h"
%include "IWriteFile.h"
%include "IXMLWriter.h"
%include "SAnimatedMesh.h"
%include "SExposedVideoData.h"
%include "SIrrCreationParameters.h"
%include "SKeyMap.h"
%include "SMesh.h"
%include "SMeshBuffer.h"
%include "SMeshBufferLightMap.h"
%include "SMeshBufferTangents.h"
%include "SSharedMeshBuffer.h"
%include "SViewFrustum.h"
%include "irrlicht.h"

%include "my.h"
%include "MySkinnedMesh.h"
%include "ISceneNode_ForInheritance.h"
%include "ConstStringArray.h"
%include "StaticStringArray.h"
%include "IFileReadCallBack_ForInheritance.h"
%include "IReadFile_ForInheritance.h"
%include "IWriteFile_ForInheritance.h"

//ev[gWJ
%template(aabbox3df) irr::core::aabbox3d<float>;
%template(arrayInt) irr::core::array<int>;
%template(arrayRectInt) irr::core::array<rectInt>;
%template(arrayStringc) irr::core::array<irr::core::stringc>;
%template(arrayStringw) irr::core::array<irr::core::stringw>;
%template(arrayVector3df) irr::core::array<irr::core::vector3df>;
%template(arraySGUISpriteFrame) irr::core::array<irr::gui::SGUISpriteFrame>;
%template(arraySGUISprite) irr::core::array<irr::gui::SGUISprite>;
%template(arrayMeshBuffer) irr::core::array<irr::scene::IMeshBuffer*>;
%template(arrayMesh) irr::core::array<irr::scene::IMesh*>;
%template(arraySceneNode) irr::core::array<irr::scene::ISceneNode*>;
//%template(arraySkinnedMeshSjoint) irr::core::array<irr::scene::ISkinnedMesh::SJoint*>;
//%template(arraySkinnedMeshSPositionKey) irr::core::array<irr::scene::ISkinnedMesh::SPositionKey>;
//%template(arraySkinnedMeshSRotationKey) irr::core::array<irr::scene::ISkinnedMesh::SRotationKey>;
//%template(arraySkinnedMeshSScaleKey) irr::core::array<irr::scene::ISkinnedMesh::SScaleKey>;
//%template(arraySkinnedMeshSWeight) irr::core::array<irr::scene::ISkinnedMesh::SWeight>;
%template(arrayQuake3SShader) irr::core::array<irr::scene::quake3::SShader>;
%template(arrayQuake3SVarGroup) irr::core::array<irr::scene::quake3::SVarGroup>;
%template(arrayQuake3SVariable) irr::core::array<irr::scene::quake3::SVariable>;
%template(arraySMD3MeshBuffer) irr::core::array<irr::scene::SMD3MeshBuffer*>;
%template(arraySMD3QuaterionTag) irr::core::array<irr::scene::SMD3QuaterionTag>;
%template(arraySMD3TexCoord) irr::core::array<irr::scene::SMD3TexCoord>;
%template(arraySMD3Vertex) irr::core::array<irr::scene::SMD3Vertex>;
%template(arraySJoystickInfo) irr::core::array<irr::SJoystickInfo>;
%template(arrayTexture) irr::core::array<irr::video::ITexture*>;
%template(arrayS3DVertex2TCoords) irr::core::array<irr::video::S3DVertex2TCoords>;
%template(arrayS3DVertexTangents) irr::core::array<irr::video::S3DVertexTangents>;
%template(arrayS3DVertex) irr::core::array<irr::video::S3DVertex>;
%template(arrayUInt) irr::core::array<unsigned int>;
%template(arrayUShort) irr::core::array<unsigned short>;
%template(arraySJoint) irr::core::array<MyIrrlicht::SJoint>;
%template(arraySRotationKey) irr::core::array<MyIrrlicht::SRotationKey>;
%template(arraySScaleKey) irr::core::array<MyIrrlicht::SScaleKey>;
%template(arraySPositionKey) irr::core::array<MyIrrlicht::SPositionKey>;
%template(arraySWeight) irr::core::array<MyIrrlicht::SWeight>;
%template(arraySSkinMeshBuffer) irr::core::array<irr::scene::SSkinMeshBuffer*>;
%template(CMatrix4f) irr::core::CMatrix4<float>;
%template(dimension2df) irr::core::dimension2d<float>;
%template(dimension2di) irr::core::dimension2d<int>;
%template(dimension2dui) irr::core::dimension2d<unsigned int>;
%template(line2df) irr::core::line2d<float>;
%template(line3df) irr::core::line3d<float>;
%template(listGUIElement) irr::core::list<irr::gui::IGUIElement*>;
%template(listSceneNodeAnimator) irr::core::list<irr::scene::ISceneNodeAnimator*>;
%template(listSceneNode) irr::core::list<irr::scene::ISceneNode*>;
%template(plane3df) irr::core::plane3d<float>;
%template(position2df) irr::core::position2d<float>;
%template(position2di) irr::core::position2d<int>;
%template(rectf) irr::core::rect<float>;
%template(recti) irr::core::rect<int>;
//%template(IrrStringc) irr::core::string<char>;
//%template(IrrStringw) irr::core::string<wchar_t>;
%template(triangle3df) irr::core::triangle3d<float>;
%template(vector2df) irr::core::vector2d<float>;
%template(vector3df) irr::core::vector3d<float>;
%template(IIrrXMLReaderCXMLBase) irr::io::IIrrXMLReader<char,irr::io::IXMLBase>;
%template(IIrrXMLReaderCReferenceCounted) irr::io::IIrrXMLReader<char,irr::IReferenceCounted>;
%template(IIrrXMLReaderLXMLBase) irr::io::IIrrXMLReader<unsigned long,irr::io::IXMLBase>;
%template(IIrrXMLReaderUSXMLBase) irr::io::IIrrXMLReader<unsigned short,irr::io::IXMLBase>;
%template(IIrrXMLReaderReferenceCounted) irr::io::IIrrXMLReader<wchar_t, irr::IReferenceCounted>;
//%template(IrrXMLReader) irr::io::IIrrXMLReader<char,irr::io::IXMLBase>;
//%template(IXMLReaderUTF8) irr::io::IIrrXMLReader<char,irr::IReferenceCounted>;
//%template(IrrXMLReaderUTF32) irr::io::IIrrXMLReader<unsigned long,irr::io::IXMLBase>;
//%template(IrrXMLReaderUTF16) irr::io::IIrrXMLReader<wchar_t,irr::io::IXMLBase>;
//%template(IXMLReaderWChar) irr::io::IIrrXMLReader<wchar_t, irr::IReferenceCounted>;
%template(_arrayPS3DVertex2TCoords) irr::core::array<irr::video::S3DVertex2TCoords*>;
%template(_arrayPS3DVertexTangents) irr::core::array<irr::video::S3DVertexTangents*>;
%template(_arrayPS3DVertex) irr::core::array<irr::video::S3DVertex*>;
%template(arrayByte) irr::core::array<unsigned char>;

%extend irr::core::string<char>
{
public:
	static irr::core::string<char>* Factory(const char* const c){return new irr::core::string<char>(c);}
}
%extend irr::core::string<wchar_t>
{
public:
	static irr::core::string<wchar_t>* Factory(const wchar_t* const c){return new irr::core::string<wchar_t>(c);}
}

%nodefault;

namespace irr
{
namespace core
{

class string<char>
{
public:
//	string<char>();
//	string(const stringc& other);
//	explicit string(const double number);
//	explicit string(int number);
//	explicit string(unsigned int number);
//	string(const char* const c, u32 length);
//	string(const char* const c);
	~string();
	stringc& operator=(const stringc& other);
	stringc& operator=(const char* const c);
	stringc operator+(const stringc& other) const;
	stringc operator+(const char* const c) const;
	char& operator [](const u32 index);
	const char& operator [](const u32 index) const;
	bool operator ==(const char* const str) const;
	bool operator ==(const stringc& other) const;
	bool operator <(const stringc& other) const;
	bool operator !=(const char* const str) const;
	bool operator !=(const stringc& other) const;
	u32 size() const;
	const char* c_str() const;
	void make_lower();
	void make_upper();
	bool equals_ignore_case(const stringc& other) const;
	bool lower_ignore_case(const stringc& other) const;
	bool equalsn(const stringc& other, u32 n) const;
	bool equalsn(const char* const str, u32 n) const;
	void append(char character);
	void append(const char* const other);
	void append(const stringc& other);
	void append(const stringc& other, u32 length);
	void reserve(u32 count);
	s32 findFirst(char c) const;
	s32 findFirstChar(const char* const c, u32 count) const;
	s32 findFirstCharNotInList(const char* const c, u32 count) const;
	s32 findLastCharNotInList(const char* const c, u32 count) const;
	s32 findNext(char c, u32 startPos) const;
	s32 findLast(char c, s32 start = -1) const;
	s32 findLastChar(const char* const c, u32 count) const;
	s32 find(const char* const str) const;
	stringc subString(u32 begin, s32 length) const;
	stringc& operator += (char c);
	stringc& operator += (const char* const c);
	stringc& operator += (const stringc& other);
	stringc& operator += (const int i);
	stringc& operator += (const unsigned int i);
	stringc& operator += (const long i);
	stringc& operator += (const unsigned long& i);
	stringc& operator += (const double i);

	stringc& operator += (const float i);
	void replace(char toReplace, char replaceWith);
	stringc& trim(const stringc & whitespace = " \t\n\r");
	void erase(u32 index);

};


class irr::core::string<wchar_t>
{
public:
//	string();
//	string(const stringw& other);
//	explicit string(const double number);
//	explicit string(int number);
//	explicit string(unsigned int number);
//	string(const wchar_t* const c, u32 length);
//	string(const wchar_t* const c);
	~string();
	stringw& operator=(const stringw& other);
	stringw& operator=(const wchar_t* const c);
	stringw operator+(const stringw& other) const;
	stringw operator+(const wchar_t* const c) const;
	wchar_t& operator [](const u32 index);
	const wchar_t& operator [](const u32 index) const;
	bool operator ==(const wchar_t* const str) const;
	bool operator ==(const stringw& other) const;
	bool operator <(const stringw& other) const;
	bool operator !=(const wchar_t* const str) const;
	bool operator !=(const stringw& other) const;
	u32 size() const;
	const wchar_t* c_str() const;
	void make_lower();
	void make_upper();
	bool equals_ignore_case(const stringw& other) const;
	bool lower_ignore_case(const stringw& other) const;
	bool equalsn(const stringw& other, u32 n) const;
	bool equalsn(const wchar_t* const str, u32 n) const;
	void append(wchar_t character);
	void append(const wchar_t* const other);
	void append(const stringw& other);
	void append(const stringw& other, u32 length);
	void reserve(u32 count);
	s32 findFirst(wchar_t c) const;
	s32 findFirstChar(const wchar_t* const c, u32 count) const;
	s32 findFirstCharNotInList(const wchar_t* const c, u32 count) const;
	s32 findLastCharNotInList(const wchar_t* const c, u32 count) const;
	s32 findNext(wchar_t c, u32 startPos) const;
	s32 findLast(wchar_t c, s32 start = -1) const;
	s32 findLastChar(const wchar_t* const c, u32 count) const;
	s32 find(const wchar_t* const str) const;
	stringw subString(u32 begin, s32 length) const;
	stringw& operator += (wchar_t c);
	stringw& operator += (const wchar_t* const c);
	stringw& operator += (const stringw& other);
	stringw& operator += (const int i);
	stringw& operator += (const unsigned int i);
	stringw& operator += (const long i);
	stringw& operator += (const unsigned long& i);
	stringw& operator += (const double i);

	stringw& operator += (const float i);
	void replace(wchar_t toReplace, wchar_t replaceWith);
	stringw& trim(const stringw & whitespace = " \t\n\r");
	void erase(u32 index);

};


}
}