//
// Inclusion of standard header file
//
#include <cmath>
#include <limits>
#include <stdexcept>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"
#include "logit.hpp"

namespace islib
  {
    //
    // Definition of function
    //
    double
    logit
      (
        double const x
      )
      {
        class local
          {
          public:
            local
              (
                double const x_
              )
              {
                throw_if ( std::invalid_argument ( "islib::logit: is_less_than ( x_, 0.0, std::numeric_limits < double >::epsilon () ) || is_greater_than ( x_, 1.0, std::numeric_limits < double >::epsilon () )" ), is_less_than ( x_, 0.0, std::numeric_limits < double >::epsilon () ) || is_greater_than ( x_, 1.0, std::numeric_limits < double >::epsilon () ) );
              }

            ~local
              ()
              throw
                ()
              {
              }
          }
          a_local ( x );

        return std::log ( x / ( 1.0 - x ) );
      }
  }

//
// End of file
//
