#ifndef DEFINES_ISLIB_NAME_HOLDER_HPP

#define DEFINES_ISLIB_NAME_HOLDER_HPP

//
// Inclusion of standard header file
//
#include <string>

namespace islib
  {
    //
    // Definition of class template
    //
    template
      <
        typename Value_Type
      >
    class name_holder
      {
      public:
        //
        // Definition of type
        //
        typedef name_holder this_type;
        typedef std::string string_type;
        typedef Value_Type value_type;

        //
        // Declaration of constructor
        //
        name_holder ();
        name_holder ( value_type const & );
        name_holder ( this_type const & );

        //
        // Declaration of destructor
        //
        ~name_holder () throw ();

        //
        // Declaration of operator
        //
        this_type &operator = ( this_type const & );
        bool operator < ( this_type const & ) const;

        //
        // Declaration of method
        //
        string_type get_name () const;
        value_type get_value () const;
        bool is_null () const;
        void swap ( this_type & ) throw ();

        //
        // Declaration of static method
        //
        string_type replace_name ( string_type const & );

      private:
        //
        // Declaration of data member
        //
        string_type name;
        value_type value;
        bool null_flag;
      };
  }

#include "name_holder.ipp"

#endif // DEFINES_ISLIB_NAME_HOLDER_HPP

//
// End of file
//
