#ifndef DEFINES_ISLIB_NAME_HOLDER_IPP

#define DEFINES_ISLIB_NAME_HOLDER_IPP

//
// Inclusion of standard header file
//
#include <algorithm>

//
// Inclusion of library header file
//
#include <boost/regex.hpp>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of constructor
    //
    template
      <
        typename Value_Type
      >
    name_holder < Value_Type >::name_holder
      (
      ):
      null_flag ( true )
      {
      }

    //
    // Definition of constructor
    //
    template
      <
        typename Value_Type
      >
    name_holder < Value_Type >::name_holder
      (
        value_type const &value_
      ):
      name ( replace_name ( value_.get_name () ) ),
      value ( value_ ),
      null_flag ( false )
      {
        class local
          {
          public:
            local
              (
                value_type const &value__
              )
              {
                throw_if ( std::invalid_argument ( "islib::name_holder < Value_Type >::name_holder: value__.is_null ()" ), value__.is_null () );
              }

            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        a_local ( value_ );
      }

    //
    // Definition of constructor
    //
    template
      <
        typename Value_Type
      >
    name_holder < Value_Type >::name_holder
      (
        this_type const &the_other
      ):
      name ( the_other.name ),
      value ( the_other.value ),
      null_flag ( the_other.null_flag )
      {
      }

    //
    // Definition of destructor
    //
    template
      <
        typename Value_Type
      >
    name_holder < Value_Type >::~name_holder
      (
      )
      throw
        (
        )
      {
      }

    //
    // Definition of operator
    //
    template
      <
        typename Value_Type
      >
    typename name_holder < Value_Type >::this_type &
    name_holder < Value_Type >::operator =
      (
        this_type const &right_value
      )
      {
        this_type temporary ( right_value );

        this->swap ( temporary );

        return *this;
      }

    //
    // Definition of operator
    //
    template
      <
        typename Value_Type
      >
    bool
    name_holder < Value_Type >::operator <
      (
        this_type const &right_value
      )
      const
      {
        class local
          {
          public:
            local
              (
                this_type const &right_value_
              )
              {
                throw_if ( std::invalid_argument ( "islib::game01::name_holder < Value_Type >::operator < : right_value_.is_null ()" ), right_value_.is_null () );
              }

            ~local
              (
              )
              throw
                (
                )
              {
              }
          }
        a_local ( right_value );

        throw_if ( std::logic_error ( "islib::game01::name_holder < Value_Type >::operator < : this->is_null ()" ), this->is_null () );

        return this->get_value () < right_value.get_value ();
      }

    //
    // Definition of method
    //
    template
      <
        typename Value_Type
      >
    typename name_holder < Value_Type >::string_type
    name_holder < Value_Type >::get_name
      (
      )
      const
      {
        string_type name_;

        class local
          {
          public:
            local
              (
                string_type const &name___
              ):
              name__ ( name___ )
              {
              }

            ~local
              (
              )
              throw
                (
                )
              {
                assert_ ( value_type::is_valid_name ( this->name__ ), "islib::name_holder < Value_Type >::get_name: `value_type::is_valid_name ( this->name__ )' has failed." );
              }

          private:
            string_type const &name__;
          }
        a_local ( name_ );

        throw_if ( std::logic_error ( "islib::name_holder < Value_Type >::get_name: this->is_null ()" ), this->is_null () );

        name_ = this->name;

        return name_;
      }

    //
    // Definition of method
    //
    template
      <
        typename Value_Type
      >
    typename name_holder < Value_Type >::value_type
    name_holder < Value_Type >::get_value
      (
      )
      const
      {
        value_type value_;

        class local
          {
          public:
            local
              (
                value_type const &value___
              ):
              value__ ( value___ )
              {
              }

            ~local
              (
              )
              throw
                (
                )
              {
                assert_ ( !this->value__.is_null (), "islib::name_holder < Value_Type >::get_value: `!this->value__.is_null ()' has failed." );
              }

          private:
            value_type const &value__;
          }
        a_local ( value_ );

        throw_if ( std::logic_error ( "islib::name_holder < Value_Type >::get_value: this->is_null ()" ), this->is_null () );

        value_ = this->value;

        return value_;
      }

    //
    // Definition of method
    //
    template
      <
        typename Value_Type
      >
    bool
    name_holder < Value_Type >::is_null
      (
      )
      const
      {
        return null_flag;
      }

    //
    // Definition of method
    //
    template
      <
        typename Value_Type
      >
    void
    name_holder < Value_Type >::swap
      (
        this_type &the_other
      )
      throw
        (
        )
      {
        this->name.swap ( the_other.name );

        this->value.swap ( the_other.value );

        std::swap ( this->null_flag, the_other.null_flag );
      }

    //
    // Definition of static method
    //
    template
      <
        typename Value_Type
      >
    typename name_holder < Value_Type >::string_type
    name_holder < Value_Type >::replace_name
      (
        string_type const &name_
      )
      {
        string_type replaced_name;

        class local
          {
          public:
            local
              (
                string_type const &name__,
                string_type const &replaced_name__
              ):
              replaced_name_ ( replaced_name__ )
              {
                throw_if ( std::invalid_argument ( "islib::name_holder < String_Type >::replace_name: name__.emtpy ()" ), name__.empty () );
              }

            ~local
              (
              )
              throw
                (
                )
              {
                assert_ ( !this->replaced_name_.empty (), "islib::name_holder < String_Type >::replace_name: `!this->replaced_name_.empty ()' has failed." );
              }

          private:
            string_type const &replaced_name_;
          }
        a_local ( name_, replaced_name );

        boost::regex const regex ( " " );
        string_type const format ( "_" );

        replaced_name = boost::regex_replace ( name_, regex, format, boost::regex_constants::match_any );

        return replaced_name;
      }
  }

#endif // DEFINES_ISLIB_NAME_HOLDER_IPP

//
// End of file
//
