//
// Inclusion of standard header file
//
#include <cstddef>
#include <stdexcept>

//
// Inclusion of system header file
//
#include <unistd.h>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"
#include "random_number_generator.hpp"
#include "system_error.hpp"

namespace islib
  {
    //
    // Definition of static data member
    //
    std::size_t random_number_generator::generate_random_number_seed_calling_times = 0;

    //
    // Definition of constructor
    //
    random_number_generator::random_number_generator
      (
        random_number_seed_type const random_number_seed,
        double const minimum_value,
        double const maximum_value
      ):
      random_number_generator_implement ( random_number_generator_engine_type ( random_number_seed ), random_number_generator_distribution_type ( minimum_value, maximum_value ) )
      {
        class local
          {
          public:
            local
              (
                double const minimum_value_,
                double const maximum_value_
              )
              {
                throw_if ( std::invalid_argument ( "islib::random_number_generator::random_number_generator: minimum_value_ >= maximum_value_" ), minimum_value_ >= maximum_value_ );
              }

            ~local
              ()
              throw
                ()
              {
              }
          }
        a_local ( minimum_value, maximum_value );
      }

    //
    // Definition of constructor
    //
    random_number_generator::random_number_generator
      (
        double const minimum_value,
        double const maximum_value
      ):
      random_number_generator_implement ( random_number_generator_engine_type ( this_type::generate_random_number_seed () ), random_number_generator_distribution_type ( minimum_value, maximum_value ) )
      {
        class local
          {
          public:
            local
              (
                double const minimum_value_,
                double const maximum_value_
              )
              {
                throw_if ( std::invalid_argument ( "islib::random_number_generator::random_number_generator: minimum_value_ >= maximum_value_" ), minimum_value_ >= maximum_value_ );
              }

            ~local
              ()
              throw
                ()
              {
              }
          }
        a_local ( minimum_value, maximum_value );
      }

    //
    // Definition of destructor
    //
    random_number_generator::~random_number_generator
      ()
      throw
        ()
      {
      }

    //
    // Definition of method
    //
    double
    random_number_generator::generate
      ()
      const
      {
        return random_number_generator_implement ();
      }

    //
    // Definition of static member function
    //
    random_number_generator::random_number_seed_type
    random_number_generator::generate_random_number_seed
      ()
      {
        random_number_seed_type const random_number_seed = static_cast < random_number_seed_type > ( time () ) + static_cast < random_number_seed_type > ( getpid () ) + static_cast < random_number_seed_type > ( generate_random_number_seed_calling_times );

        ++generate_random_number_seed_calling_times;

        return random_number_seed;
      }
  }

//
// End of file
//
