//
// Inclusion of standard header file
//
#include <cmath>
#include <limits>

//
// Inclusion of local header file
//
#include "islibdef.hpp"
#include "islibfunc.hpp"
#include "sigmoid.hpp"

namespace islib
  {
    //
    // Definition of funcion
    //
    double
    sigmoid
      (
        double const x
      )
      {
        double y;

        class local
          {
          public:
            local
              (
                double const &y__
              ):
              y_ ( y__ )
              {
              }

            ~local
              ()
              throw
                ()
              {
                assert_ ( is_greater_than_or_equals_to ( this->y_, 0.0, std::numeric_limits < double >::epsilon () ) && is_less_than_or_equals_to ( this->y_, 1.0, std::numeric_limits < double >::epsilon () ), "islib::sigmoid: `is_greater_than_or_equals_to ( this->y_, 0.0, std::numeric_limits < double >::epsilon () ) && is_less_than_or_equals_to ( this->y_, 1.0, std::numeric_limits < double >::epsilon () )' has failed." );
              }

          private:
            double const &y_;
          }
        a_local ( y );

        y = 1.0 / ( 1.0 + std::pow ( E, -x ) );

        return y;
      }
  }

//
// End of file
//
