//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_time.h
 * @brief		iris unit test time utility t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_time_H_C6B9E65B_4059_4175_A6DB_397DBF338AA8_
#define INCG_IRIS_iutest_time_H_C6B9E65B_4059_4175_A6DB_397DBF338AA8_

//======================================================================
// include
#include "iutest_internal_defs.h"
#include "iutest_string.h"
#include <time.h>

namespace iutest {
namespace detail
{

//======================================================================
// function
/**
  * @internal
  * @brief	TimeInMillisec to string
  * @param	[in]	msec	= ~b
  * @return	b̕
*/
inline std::string	FormatTimeInMillisecAsSecond(TimeInMillisec msec)
{
	detail::iuStringStream::type ss;
	ss << msec/1000.0;
	return ss.str();
}

/**
 * @brief	ݎ̎擾
*/
inline time_t	GetTime(void)
{
#if IUTEST_HAS_CTIME
	return time(NULL);
#else
	return 0;
#endif
}

/**
 * @brief	sȒl̎擾
*/
inline unsigned int GetIndefiniteValue(void)
{
#if IUTEST_HAS_CTIME
	return static_cast<unsigned int>(GetTime());
#elif	defined(IUTEST_SUPPORT_CLOCK)
	return static_cast<unsigned int>(clock());
#elif defined(IUTEST_OS_WINDOWS)
	return static_cast<unsigned int>(GetTickCount());
#else
	// ȂׂɂȂȂ悤ɂ
	static unsigned int s = 20120206;
	s = s*1664525 + 1013904223;
	return s;
#endif
}

//======================================================================
// class
/**
 * @internal
 * @brief	XgbvEHb`NX
*/
class iuStopWatch
{
private:
	TimeInMillisec	m_begin;
public:
	iuStopWatch(void) : m_begin(0)	{}

public:
	// ݂̎Ԃ~bPʂŎ擾
	static TimeInMillisec	get_millisec(void)
	{
#if		defined(IUTEST_NOT_SUPPORT_STOPWATCH)
		return 0;
#else

#if		defined(IUTEST_GetMillisec)
		return IUTEST_GetMillisec();

#elif	defined(IUTEST_SUPPORT_GETTIMEOFDAY)
		timeval tv;
		gettimeofday(&tv, NULL);
		return static_cast<TimeInMillisec>(tv.tv_sec) * 1000 + static_cast<TimeInMillisec>(tv.tv_usec) / 1000;
#elif	defined(IUTEST_SUPPORT_CLOCK)
		return clock() * 1000 / CLOCKS_PER_SEC;

#else

#if defined(IUTEST_OS_WINDOWS)
		return GetTickCount();
#else
#  define IUTEST_NOT_SUPPORT_STOPWATCH
		return 0;
#endif

#endif

#endif
	}
public:
	void			start(void)
	{
		m_begin = get_millisec();
	}
	TimeInMillisec	stop(void) const
	{
		return get_millisec() - m_begin;
	}
};

}	// end of namespace detail
}	// end of namespace iutest

#endif
