//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_disabled_tests.cpp
 * @brief		also_run_disabled_tests ΉeXg
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "../include/iutest.hpp"

#include <assert.h>

IUTEST(DISABLED_Foo, Bar)
{
	IUTEST_ASSERT_EQ(2, 3);
}

IUTEST(Foo, DISABLED_Bar)
{
	IUTEST_ASSERT_EQ(2, 3);
}

IUTEST(Foo, Bar)
{
	IUTEST_ASSERT_EQ(3, 3);
}

#ifdef UNICODE
int wmain(int argc, wchar_t* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	iutest::IUTEST_FLAG(also_run_disabled_tests) = true;
	
	IUTEST_INIT(&argc, argv);
	int ret = IUTEST_RUN_ALL_TESTS();	// run all
	assert( iutest::UnitTest::GetInstance()->disabled_test_count() == 2 );
	assert( iutest::UnitTest::GetInstance()->test_to_run_count() == 3 );
	assert( iutest::UnitTest::GetInstance()->failed_test_count() == 2 );
	assert( iutest::UnitTest::GetInstance()->total_test_count() == 3 );
	if( ret != 0 ) printf("*** Successful ***\n");
	return ret == 1 ? 0 : 1;
}
