//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_ver.hpp
 * @brief		iris unit test version ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_ver_HPP_D65CB7A7_D2AD_40fe_8F5F_8FBF376A0010_
#define INCG_IRIS_iutest_ver_HPP_D65CB7A7_D2AD_40fe_8F5F_8FBF376A0010_

//======================================================================
// include

//======================================================================
// define
#define	IUTEST_VER			0x01050000u	//!< iutest version 1.5.0.0
#define IUTEST_MAJORVER		0x01u		//!< Major Version
#define IUTEST_MINORVER		0x05u		//!< Minor Version
#define IUTEST_BUILD		0x00u		//!< Build
#define IUTEST_REVISION		0x00u		//!< Revision

/**
 * @mainpage
 * @sa	@b	ProjectHome \n
 *			sourceforge : http://sourceforge.jp/projects/iutest/ \n
 *			github      : https://github.com/srz-zumix/iutest \n
 *
 * @par		copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 *
 * @par		LICENSE

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:\n
\n
  1. Redistributions of source code must retain the above copyright notice,\n
     this list of conditions and the following disclaimer.\n
  2. Redistributions in binary form must reproduce the above copyright notice,\n
     this list of conditions and the following disclaimer in the documentation \n
     and/or other materials provided with the distribution.\n
  3. the copyright holder's name is not used to endorse products \n
     built using this software without specific written permission.\n
\n
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/**
 * @page	CMDLINE		R}hCIvV
 * @par		Command Line Options
 <table>
   <tr><td>--help, -h                        </td><td></td><td>generate help message.</td></tr>
   <tr><td>--iutest_output                   </td><td>xml[:path]</td><td>path of xml report.</td></tr>
   <tr><td>--iutest_list_tests               </td><td></td><td>list up tests.</td></tr>
   <tr><td>--iutest_list_tests_with_where    </td><td></td><td>list up tests with where.</td></tr>
   <tr><td>--iutest_color                    </td><td>&lt;yes|no|auto|ansi&gt;</td><td>console color enable.</td></tr>
   <tr><td>--iutest_filter                   </td><td>&lt;filter&gt;</td><td>Select the test run.</td></tr>
   <tr><td>--iutest_shuffle                  </td><td></td><td>do shuffle test.</td></tr>
   <tr><td>--iutest_random_seed              </td><td>&lt;seed&gt;</td><td>set random seed.</td></tr>
   <tr><td>--iutest_also_run_disabled_tests  </td><td></td><td>run disabled tests.</td></tr>
   <tr><td>--iutest_break_on_failure         </td><td>[0|1]</td><td>When that failed to break.</td></tr>
   <tr><td>--iutest_throw_on_failure         </td><td>[0|1]</td><td>When that failed to throw.</td></tr>
   <tr><td>--iutest_catch_exceptions         </td><td>&lt;0|1&gt;</td><td>catch exceptions enable.</td></tr>
   <tr><td>--iutest_print_time               </td><td>&lt;0|1&gt;</td><td>Setting the display of elapsed time.</td></tr>
   <tr><td>--iutest_repeat                   </td><td>&lt;count&gt;</td><td>Set the number of repetitions of the test.</td></tr>
   <tr><td>--iutest_file_location            </td><td>&lt;auto|vs|gcc&gt;</td><td>Format file location messages.</td></tr>
   <tr><td>--feature                         </td><td></td><td>show iutest feature.</td></tr>
   <tr><td>--version, -v                     </td><td></td><td>show iutest version.</td></tr>
 </table>
  * yes or no option can use "yes|y|on|true|t|1|no|n|off|false|f|0"
*/

/**
 * @page	CHANGELOG		ύX
 * @par		Changes
 <ul>
  <li>v1.5.0.0
    <ul>
      <li>{eXgɑΉ</li>
      <li>SetUpTestCase Ȃǂ̃eXgsȊOł RecordProperty ł悤ɕύX</li>
      <li>iutest_list_tests_with_where R}hCIvVǉ</li>
      <li>IUTEST_TYPED_TEST_CASE,IUTEST_TYPED_TEST_CASE_P ɒ ::iutest::Types 悤ɏC/li>
      <li>gꍇɃG[o͂悤ɏC</li>
      <li>IUTEST_PEEP ̎dlύX</li>
      <li>MiniDump o͂ɑΉ</li>
      <li>noexcept ɑΉ</li>
    </ul>
  </li>
  <li>v1.4.0.0
    <ul>
      <li>IUTEST_ASSERT_*  void ȊO̖߂lԂ悤ɏC(::iutest::AssertionReturn)</li>
      <li>::iutest::Types o[Ɍ^擾 get ǉ</li>
      <li>::iutest::ValuesIn  initializer_list ɑΉ</li>
      <li>l̃p[^eXgɔCӂ̃p[^𐶐 ValuesGen ǉ</li>
      <li>l̃p[^eXgɗp[^𐶐 RandomValues ǉ</li>
      <li>extern template Ή</li>
      <li>C++11 random wb_[gpłƂ distribution g悤ɕύX</li>
      <li>R[h̓c[̂߂̃R[h̒ǉ(__analysis_assume)  IUTEST_*_NULL  IUTEST_*_NOTNULL ɒǉ(MSVC)</li>
	  <li>ÂRpCւ̑Ή</li>
    </ul>
  </li>
  <li>v1.3.1.0
    <ul>
      <li>IUTEST_SKIP Ƃ̃Oǉ</li>
      <li>IUTEST_SKIP() << "message" ɑΉ</li>
      <li>XLbveXg̃Oo͂C</li>
      <li>RpC̒ʂȂeXgR[heXg}N(*_IGNORE)ǉ</li>
    </ul>
  </li>
  <li>v1.3.0.1
    <ul>
      <li>IUTEST_THROW_ON_ASSERT_FAILURE  IUTEST_USE_THROW_ON_ASSERT_FAILURE ɕύX</li>
      <li>IUTEST_FRIEND_TYPED_TEST ǉ</li>
      <li>V[hJԂɕKς悤ɏC</li>
      <li>GTEST Ŏn܂ϐɑΉ</li>
      <li>bZ[Wo͂̃t@C/s̃tH[}bg𓮓IɕύXłIvVǉ(--iutest_file_location)</li>
      <li>gtest [hł̃rhG[C</li>
      <li>IUTEST_*_FATAL_FAILURE, IUTEST_*_NONFATAL_FAILURE  lambda 𗘗pĕϐɃANZXł悤ɏC</li>
      <li>IUTEST_*_NO_FATAL_FAILURE  FATAL FAILURE ݂̂Ŕf悤ɕύX</li>
      <li>IUTEST_*_NO_FAILURE ǉ</li>
      <li>CurhΉ</li>
      <li>CUDA Ή</li>
      <li>explicit conversion operator Ή</li>
    </ul>
  </li>
  <li>v1.2.0.2
    <ul>
      <li>IUTEST_*_EQ_COLLECTIONS AT[Vǉ</li>
      <li>Android NDK Ή</li>
      <li>OԂ񋟂 IUTEST_PACKAGE ǉ</li>
      <li>IUTEST_*_STRNE, IUTEST_*_STRCASENE ̎sbZ[WP</li>
      <li>vOXo̓Xi[ǉ</li>
    </ul>
  </li>
  <li>v1.1.2.0
    <ul>
      <li>IUTEST_*_NO_THROW ŎsƂɗȌo͂悤ɏC</li>
      <li>printer C</li>
    </ul>
  </li>
  <li>v1.1.1.2
    <ul>
      <li>Windows Mobile ł̃rhG[C</li>
      <li>IUTEST_HAS_STRINGSTREAM=0 ̂Ƃ̃rhG[C</li>
      <li>錾ƒ`𕪗</li>
    </ul>
  </li>
  <li>v1.1.0.0
    <ul>
      <li>v1.1.0 [Xo[W</li>
    </ul>
  </li>
  <li>v1.0.7.1
    <ul>
      <li>2oCg xml ɐo͂ȂCisetlocale Kvj</li>
      <li>O̒lqAT[V IUTEST_*_THROW_PRED_FORMAT2 ǉ</li>
      <li>O̒lAT[ṼOo͂C</li>
    </ul>
  </li>
  <li>v1.0.6.0
    <ul>
      <li>O̒lAT[V EQ/NE/STREQ/STRCASEEQ ɏC</li>
    </ul>
  </li>
  <li>v1.0.5.2
    <ul>
      <li>IȃXLbvƂ IUTEST_SKIP ǉ</li>
      <li>R\[o͐𓮓IɕύXł悤ɏC</li>
      <li>sׂeXgsȂꍇɎso͂悤ɏC</li>
      <li>Visual Studio UnitTest Framework  IUTEST_P,IUTEST_TYPED_TEST,IUTEST_TYPED_TEST_P gpł悤ɏC(tr1)</li>
    </ul>
  </li>
  <li>v1.0.4.0
    <ul>
      <li>iutest::Pairwise ǉ</li>
      <li>R[hTCY팸</li>
    </ul>
  </li>
  <li>v1.0.3.1
    <ul>
      <li>t@CpX⏕NX̒ǉ</li>
      <li>IUTEST_*_EQ  if( expected == actual )  if( actual == expected ) ɕύX</li>
      <li>IUTEST_*_NO_FATAL_FAILURE ɋ statement ^ĂxoȂ悤ɏC</li>
    </ul>
  </li>
  <li>v1.0.2.0
    <ul>
      <li>O̒lAT[Vǉ</li>
    </ul>
  </li>
  <li>v1.0.1.0
    <ul>
      <li>CRT ZLeB֐̎snhɑΉ</li>
      <li>iutest::InitIrisUnitTest Ă΂ĂȂꍇɌxo悤ɕύX</li>
    </ul>
  </li>
  <li>v1.0.0.0
    <ul>
      <li>[X</li>
    </ul>
  </li>
  <li>v0.36.2.1
    <ul>
      <li>^\Lf}O悤ɏC</li>
      <li>Google Test gpꍇł std::string ɑΉrAT[Vg悤ɏC</li>
      <li>Google Test gp wchar_t ł STRCASENE g悤ɏC</li>
      <li>IUTEST_THROW_ON_ASSERT_FAILURE ̃ftHgl 0 ɕύX</li>
      <li>IUTEST_THROW_ON_ASSERT_FAILURE LȂƂ IUTEST_*_FATAL_FAILURE 삵ȂC</li>
      <li>spi eXg break_on_failure/throw_on_failure Ŏ~܂Ȃ悤ɏC</li>
      <li>AT[V݂̗̂pł悤ɏC</li>
      <li>O[oXR[vZq悤ɏC</li>
      <li>Google Test ̃o[Wʂǉ</li>
    </ul>
  </li>
  <li>v0.35.0.0
    <ul>
      <li>IUTEST_PMZ, IUTEST_PMZ_F eXg}Nǉ</li>
    </ul>
  </li>
  <li>v0.34.0.0
    <ul>
      <li> IUTEST_REGISTER_TYPED_TEST_CASE_P łȂsC</li>
      <li>eXgfۂɎsȂeXg notrun  XML o͂悤ɏC</li>
      <li>--iutest_break_on_failure LɂfobOȂsƂɃ_CAOłȂ悤ɏC</li>
    </ul>
  </li>
  <li>v0.33.1.0
    <ul>
      <li>iutest::UnitTest::repeat_counter ֐ǉ</li>
      <li>OnTestIterationStart/End  iteration  0 n܂悤ɏC</li>
      <li>QuietResultPrinter ǉ</li>
      <li>util C</li>
    </ul>
  </li>
  <li>v0.32.0.0
    <ul>
      <li>iutest::Combine ϒɑΉ</li>
      <li>IUTEST_PEEP  cv CꂽoɑΉ</li>
      <li>eXgŚAeXgP[X̌oߎԂ̌v@ύX</li>
    </ul>
  </li>
  <li>v0.31.2.1
    <ul>
      <li>IUTEST_STATIC_ASSERT ǉ</li>
      <li>IUTEST_SCOPED_TRACE  gtest ƓL@g悤ɏC</li>
      <li>std::chrono::high_resolution_clock ɑΉ</li>
      <li>iutest::PrintToString ŃXg[o͂łȂ^ɑΉioCgzój</li>
      <li>eXgp̃V[h擾ǉ</li>
      <li>IUTEST_*_TRUE|FALSE  iutest::AssertionResult 󂯎悤ɏC</li>
      <li>--feature IvVǉ</li>
    </ul>
  </li>
  <li>v0.30.1.0
    <ul>
      <li>IUTEST_*_STREQ, IUTEST_*_STRNE  char16_t, char32_t ɑΉ</li>
      <li>ꕔ̊ŃCh IUTEST_*_STRCASEEQ, IUTEST_*_STRCASENE 啶ʂĂsC</li>
      <li>nullptr ɑΉ</li>
      <li>V[hw肵ȂꍇɌݎi~bjV[h肷悤ɏC</li>
      <li>VbteXgɗV[hOo͂悤ɏC</li>
      <li>擾p̃RtBO}Nǉ</li>
      <li>iutest::PrintToString ŃRpCʂȂ^̂ŏC</li>
      <li>EQnAT[ṼbZ[WC</li>
    </ul>
  </li>
  <li>v0.29.1.0
    <ul>
      <li>IUTEST_INSTANTIATE_TYPED_TEST_CASE_P ̌^XgɒP̌^(int, char...)gpł悤ɏC</li>
      <li>ASSERT }NO throw 邩ݒ肷 IUTEST_THROW_ON_ASSERT_FAILURE ǉ(default=1) </li>
      <li>--iutest_throw_on_failure ɒvIł͂ȂG[Ŏsꍇ throw ȂsC</li>
      <li>2 IUTEST_RUN_ALL_TESTS Ƃ̕sC</li>
      <li>Environment ̉^C~OC</li>
    </ul>
  </li>
  <li>v0.28.0.1
    <ul>
      <li>iutest::Environment::SetUp ȂǃeXgȊȌꏊŎsꍇɑΉ</li>
    </ul>
  </li>
  <li>v0.27.0.0
    <ul>
      <li>namespace l IUTEST_MAKE_SCOPED_PEEP, IUTEST_SCOPED_PEEP }Nǉ</li>
      <li>iutest::AddGlobalTestEnvironment gƃRpCG[ɂȂC</li>
      <li>iutest::Environment  new Ďg悤ɎdlύX</li>
      <li>iutest::Environment  TearDown ̎s SetUp ̋tɕύX</li>
    </ul>
  </li>
  <li>v0.26.2.0
    <ul>
      <li>RecordProperty ŃL[dꍇɏ㏑悤ɏC</li>
      <li>IUTEST_HAS_PEEP, IUTEST_HAS_PEEP_FUNC, IUTEST_PEEP_STATIC_FUNC RtBO}Nǉ</li>
      <li>iutest_prod.hpp  private o[ւ̃ANZX@\ǉ(IUTEST_MAKE_PEEP, IUTEST_PEEP_GET etc...)</li>
      <li>IUTEST_FRIEND_TEST sC</li>
    </ul>
  </li>
  <li>v0.25.2.0
    <ul>
      <li>gtest Ƃ̌݊ƂĂȂӏC</li>
      <li>IUTEST_FLAG  filter ǉ</li>
      <li>IvVɑΉĂȂlw肵ƂɃwvo͂悤ɏC</li>
      <li>^Ulw肷R}hCIvV yes|no ɑΉ</li>
      <li>xml o͂ type param, value param o͂悤ɏC</li>
      <li>RTTI LȂƂɌ^񂪏o͂ĂȂC</li>
      <li>PrintTo  tuple ɑΉ</li>
    </ul>
  </li>
  <li>v0.24.1.0
    <ul>
      <li>Test Anything Protocol t@Co̓Xi[ǉ</li>
      <li>DISABLE eXg xml  run Ƃďo͂C</li>
      <li>DISABLE eXg֌W̕sC</li>
      <li>IUTEST_REPORT_SKIPPED }NŃftHgxmlo̓Xi[ skip o͂邩Ił悤ɏC</li>
      <li>0|1 ̃tOnIvV yes|no, y|n, true|false, t|f g悤ɏC</li>
      <li>--iutest_color  ANSI IvVǉiGXP[vV[PXŐFój</li>
      <li>--iutest_color ő啶ʂȂ悤ɏC</li>
    </ul>
  </li>
  <li>v0.23.3.0
    <ul>
      <li>IUTEST_*_SAME AT[Vǉ</li>
      <li>IUTEST_*_NULL, IUTEST_*_NOTNULL AT[Vǉ</li>
      <li>Test Anyting Protocol Xi[̒ǉ</li>
      <li>ftHgXi[Ƃ NULL QƂsC</li>
      <li>eXg[eBeB̃eXgp iutest_spi.hpp ǉ</li>
      <li>IUTEST_*_STR* AT[V NULL ^ĎsƗC</li>
      <li>--iutest_throw_on_failure=1 ŃeXgŜ𒆒f悤ɕύX</li>
    </ul>
  </li>
  <li>v0.22.0.1
    <ul>
      <li>Variadic Templates Ήiiutest::Types, iutest::Valuesj</li>
      <li>Variadic Templates ɑΉqAT[VǉiIUTEST_*_PREDj</li>
      <li>IUTEST_*_PRED_FORMAT ǉ</li>
      <li>--iutest_throw_on_failure=1 ƂƂAeXgɗOƃeXg catch ȂsC</li>
    </ul>
  </li>
  <li>v0.21.0.1
    <ul>
      <li>IUTEST_*_NO_FATAL_FAILURE ǉ</li>
      <li>STRCASEEQ, STRCASENE  ASSERT łgȂC</li>
      <li>IUTEST_*_PRED5 RpCG[ɂȂC</li>
      <li>INFORM }NꕔRpCG[ɂȂC</li>
      <li>gcc ŗOg邩ǂ̔肪tɂȂĂC</li>
      <li>AT[V}Nɓn̏o͂C</li>
      <li>Visual Studio 11 Ή</li>
      <li>clangΉ</li>
      <li>Tv\[XC</li>
    </ul>
  </li>
  <li>v0.20.0.0
    <ul>
      <li>--iutest_filter gpƂɁAseXgo͂oȂsC</li>
      <li>eXgAeXgP[X̎擾֐AsĂȂ̂܂߂ĂȂsC</li>
      <li>eXgAeXgP[X̎sis\j̎擾֐ǉ</li>
      <li>IUTEST_*_STREQ Ar}N NULL nꍇɗOsC</li>
      <li>IUTEST_RUN_ALL_TESTS ̖߂lԈĂsC</li>
    </ul>
  </li>
  <li>v0.19.0.0
    <ul>
      <li>CxgXi[ RecordProperty ̃Cxgǉ</li>
      <li>google mock Ή</li>
      <li>IUTEST_*_STRCASE*  std::string ̂܂܎g悤ɏC</li>
      <li>rvalue reference Ή</li>
    </ul>
  </li>
  <li>v0.18.1.1
    <ul>
      <li>On*End CxǵAXǧ납s悤ɕύX</li>
      <li>xpisɂȂȂjeXg IUTEST_INFORM_*** }Nǉ</li>
      <li>iutest::TestPartResult ̃C^[tFCXC</li>
      <li>G[o͂ Actual  Expected tɂȂĂsC</li>
      <li>char  unsigned char  0 bZ[Wo͂ۂɃkɂȂȂ悤ɏC</li>
      <li>^[~i̐Fo͏C</li>
      <li>Visual Studio ȊOŃrhꍇ̊ϐɑΉ</li>
      <li>IUTEST_ASSERT_EQ ̃G[o͂A Actual  Expected tɂȂĂsC</li>
    </ul>
  </li>
  <li>v0.17.0.0
    <ul>
      <li>.h  .hpp ɕύX</li>
      <li>gtest ̃R}hCɑΉ</li>
      <li>--iutest_filter IvV *Test*-*TestA* ̂悤ɏOtB^Ƃɐ삵ȂsC</li>
    </ul>
  </li>
  <li>v0.16.1.1
    <ul>
      <li>iutest::InitIrisUnitTest  vector Ή</li>
      <li>NaCl, ARM Ή</li>
      <li>RecordProperty  template Ή</li>
    </ul>
  </li>
  <li>v0.16.0.2
    <ul>
      <li>^AT[V Ή</li>
      <li>RecoredProperty Ή</li>
      <li>iutest::Combine Ή/li>
      <li>^p[^eXg<ɑΉ/li>
      <li>googletest Ƃ̐؂ւΉ</li>
      <li>googletest Ƃ̍قz</li>
      <li>vIȎs throw IvVΉ( --iutest_throw_on_failure=<0|1> )</li>
      <li>oߎԂ̏o̓IvVΉ( --iutest_print_time=<0|1> )</li>
      <li>seXg̑IIvVΉ( --iutest_filter=selection )</li>
      <li>iutest::PrintToString Ή</li>
      <li>IUTEST_FLAG }NɂIvVwɑΉ</li>
      <li>JԂIvVΉ( --iutest_repeat=count )</li>
      <li>CxgXi[Ή</li>
      <li>O[oZbgɑΉ(iutest::AddGlobalTestEnvironment)</li>
      <li>eXgpɏqAT[Ṽwp[ǉ(iuutil::CmpHelperOR)</li>
      <li>^teXgΉ</li>
      <li>eXgɗ@\ǉ( genrand )</li>
      <li>ϐł̃eXgIvVwɑΉ</li>
      <li>DISABLEDeXgsIvVΉ( --iutest_also_run_disabled_tests )</li>
      <li>OLb`IvVΉ( --iutest_catch_exceptions=<0|1> )</li>
      <li>su[NIvVΉ( --iutest_break_on_failure )</li>
      <li>VbteXgΉ</li>
      <li>o̓J[IvVΉ( --iutest_color=<yes|no|auto> )</li>
      <li>wvIvVΉ( --help )</li>
      <li>p[^eXgΉ</li>
      <li>DISABLED_ ɑΉ</li>
      <li>xml o͂ɑΉ</li>
    </ul>
  </li>
</ul>
*/

#endif
