/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.tomcat.util.buf.B2CConverter;

public abstract class WebSocketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(B2CConverter.ISO_8859_1);
    private MessageDigest sha1Helper;

    public void init() throws ServletException {
        super.init();
        try {
            this.sha1Helper = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subProtocol = null;
        List extensions = Collections.emptyList();
        if (!this.headerContainsToken(req, "upgrade", "websocket")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "connection", "upgrade")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
            resp.setStatus(426);
            resp.setHeader("Sec-WebSocket-Version", "13");
            return;
        }
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            resp.sendError(400);
            return;
        }
        String origin = req.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            resp.sendError(403);
            return;
        }
        List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol-Client");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        resp.setHeader("upgrade", "websocket");
        resp.setHeader("connection", "upgrade");
        resp.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
        if (subProtocol != null) {
            resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        if (!extensions.isEmpty()) {
            // empty if block
        }
        StreamInbound inbound = this.createWebSocketInbound(subProtocol);
        ((RequestFacade)req).doUpgrade(inbound);
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return true;
    }

    private List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWebSocketAccept(String key) {
        MessageDigest messageDigest = this.sha1Helper;
        synchronized (messageDigest) {
            this.sha1Helper.reset();
            this.sha1Helper.update(key.getBytes(B2CConverter.ISO_8859_1));
            return Base64.encode(this.sha1Helper.digest(WS_ACCEPT));
        }
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }

    protected abstract StreamInbound createWebSocketInbound(String var1);
}

