package cx.ath.kgslab.spring.axis.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;

import javax.xml.rpc.server.ServletEndpointContext;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * Spring Bean Handler.
 * SpringBeanEFuT[rXƂČJB
 * JWSHandler̎x[XɁAS2AxisS2Handler̎Qlɍ쐬B
 * @author NAGASAWA Takahiro
 * @see org.apache.axis.handlers.JWSHandler
 * @see org.seasar.axis.server.S2Handler
 */
public class SpringBeanHandler extends BasicHandler {
  private final Map soapServices = new HashMap();

  //  private ServletEndpointContext servletEndpointContext = null;
  private WebApplicationContext webApplicationContext = null;

  /**
   * @param msgContext bZ[WReLXg
   * @throws AxisFault
   * @see org.apache.axis.Handler#invoke(org.apache.axis.MessageContext)
   */
  public void invoke(final MessageContext msgContext)
    throws AxisFault {
    try {
      setupService(msgContext);
    } catch (final Exception e) {
      log.error(Messages.getMessage("exception00"), e);
      throw AxisFault.makeFault(e);
    }
  }

  /**
   *
   * @param msgContext bZ[WReLXg
   * @throws Exception
   */
  protected void setupService(final MessageContext msgContext)
    throws Exception {
    if (webApplicationContext == null) {
      ServletEndpointContext servletEndpointContext =
        (ServletEndpointContext) msgContext.getProperty(
          "servletEndpointContext");

      ServletContext servletContext =
        servletEndpointContext.getServletContext();
      webApplicationContext =
        WebApplicationContextUtils
        .getRequiredWebApplicationContext(servletContext);
    }

    final String componentName = getComponentName(msgContext);

    if (componentName == null) {
      return;
    }

    SOAPService service = getService(msgContext, componentName);
    if (service != null) {
      msgContext.setService(service);
    }
  }

  /**
   * pX͂āAR|[lg擾.
   * <br/>
   * pXR|[lgɕϊƂɂ́A
   * 擪'/''@'ɒuǍ'/''.'ɒuB
   * @param msgContext bZ[WReLXg
   * @return R|[lg
   */
  protected String getComponentName(
    final MessageContext msgContext) {
    final String pathInfo =
      (String) msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);

    if ((pathInfo == null) || (pathInfo.length() == 0)) {
      return null;
    }

    return "@" + pathInfo.substring(1).replace('/', '.');
  }

  /**
   *
   * @param msgContext bZ[WReLXg
   * @param componentName R|[lg
   * @return
   * @throws AxisFault
   */
  protected SOAPService getService(
    final MessageContext msgContext, final String componentName)
    throws AxisFault {
    SOAPService soapService =
      (SOAPService) soapServices.get(componentName);

    if (soapService == null) {
      soapService = createService(msgContext, componentName);
      soapServices.put(componentName, soapService);
    }

    soapService.setEngine(msgContext.getAxisEngine());
    soapService.init(); // ??

    return soapService;
  }

  /**
   * T[rX̐
   * @param msgContext bZ[WReLXg
   * @param componentName R|[lg
   * @return T[rX
   * @throws AxisFault
   */
  protected SOAPService createService(
    final MessageContext msgContext, final String componentName)
    throws AxisFault {
    final SOAPService soapService =
      new SOAPService(new SpringRPCProvider());
    final Object bean =
      webApplicationContext.getBean(componentName);

    if (bean instanceof AxisExporter) {
      final AxisExporter exporter = (AxisExporter) bean;
      final Class beanClass = exporter.getBean().getClass();
      final String componentClassName = beanClass.getName();
      soapService.setName(componentClassName);
      soapService.setOption(SpringRPCProvider.OPTION_CLASSNAME,
        componentClassName);
      soapService.setOption(SpringRPCProvider.OPTION_APPLICATION_CONTEXT,
        webApplicationContext);
      soapService.setOption(SpringRPCProvider.OPTION_COMPONENT_NAME,
        componentName);

      String allowedMethods = getAllowedMethod(exporter);

      if ((allowedMethods != null)
            && (allowedMethods.length() > 0)) {
        soapService.setOption(SpringRPCProvider.OPTION_ALLOWEDMETHODS,
          allowedMethods);
      } else {
        soapService.setOption(SpringRPCProvider.OPTION_ALLOWEDMETHODS,
            "*");
      }

      soapService.getInitializedServiceDesc(msgContext);

      final TypeMappingRegistry regs =
        msgContext.getTypeMappingRegistry();
      final Object[] typeMappings = exporter.getTypeMappings();

      for (int i = 0; i < typeMappings.length; i++) {
        try {
          TypeMappingDefinition.registerTypeMapping(regs,
            typeMappings[i]);
        } catch (ClassNotFoundException e) {
          throw AxisFault.makeFault(e);
        }
      }
    }

    return soapService;
  }

  /**
   * @param exporter
   * @return
   */
  private String getAllowedMethod(AxisExporter exporter) {
    Set set = new HashSet();
    String[] methods = exporter.getAllowedMethods();
    Class[] interfaces = exporter.getAllowedInterfaces();

    if ((methods != null) && (methods.length > 0)) {
      for (int i = 0; i < methods.length; i++) {
        set.add(methods[i]);
      }
    }

    if ((interfaces != null) && (interfaces.length > 0)) {
      for (int i = 0; i < interfaces.length; i++) {
        Class itfc = interfaces[i];

        if (itfc.isInterface()) {
          Method[] mthds = itfc.getMethods();

          if ((methods != null) && (mthds.length > 0)) {
            for (int j = 0; j < mthds.length; j++) {
              Method method = mthds[j];

              if ((method.getModifiers() & Modifier.PUBLIC) != 0) {
                set.add(method.getName());
              }
            }
          }
        }
      }
    }

    if (!set.isEmpty()) {
      StringBuffer buf = new StringBuffer();
      Iterator ite = set.iterator();

      while (ite.hasNext()) {
        String method = (String) ite.next();

        if (!method.equals("*")) {
          buf.append(method).append(' ');
        }
      }

      if (buf.length() > 0) {
        return buf.toString().trim();
      }
    }

    return null;
  }

  /**
   * WSDL̐.
   * @param msgContext bZ[WReLXg
   */
  public void generateWSDL(MessageContext msgContext)
    throws AxisFault {
    try {
      setupService(msgContext);
    } catch (Exception e) {
      log.error(Messages.getMessage("exception00"), e);
      throw AxisFault.makeFault(e);
    }
  }
}
