/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.client;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public class AxisInvocationInterceptor
implements MethodInterceptor,
InitializingBean,
BeanFactoryAware {
    private Service service = null;
    private String url = null;
    private Object[] typeMappings = null;
    private BeanFactory beanFactory = null;

    public void setService(Service service) {
        this.service = service;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Call call = this.service.createCall();
        call.setTargetEndpointAddress(this.url);
        call.setOperationName(new QName("http://soapinterop.org/", method.getName()));
        return call.invoke(invocation.getArguments());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.service == null) {
            Object bean = null;
            this.service = this.beanFactory.containsBean("service") && (bean = this.beanFactory.getBean("service")) instanceof Service ? (Service)bean : new Service();
        }
        if (this.typeMappings != null && this.typeMappings.length > 0) {
            TypeMappingRegistry regs = (TypeMappingRegistry)this.service.getTypeMappingRegistry();
            int i = 0;
            while (i < this.typeMappings.length) {
                TypeMappingDefinition.registerTypeMapping(regs, this.typeMappings[i]);
                ++i;
            }
        }
    }

    public void setTypeMappings(Object[] typeMappings) {
        this.typeMappings = typeMappings;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

