/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "enemy.h"
#include "common.h"
#include "status.h"

CEnemy::CEnemy(int strong)
{
  m_strong = strong;
}
int CEnemy::getStrong()
{
  return m_strong;
}

void CEnemy::setImages(QPixmap *img[])
{
  int i;

  for(i = 0; i< CENEMY_IMGCNT ;i++){
    m_Img[i] = img[i];
  }

}
QPixmap* CEnemy::getNormalImage()
{
  return m_Img[0];
}
QPixmap* CEnemy::getWinImage()
{
  return m_Img[2];
}
QPixmap* CEnemy::getLostImage()
{
  return m_Img[1];
}
QPixmap* CEnemy::getImage()
{
  QPixmap *img;

  switch(STS_getSubStatus()){

  case P1_WIN:
    img = m_Img[1];
    break;

  case P2_WIN:
    img = m_Img[2];
    break;

  default:
    img = m_Img[0];
  }

  return img;

}







