/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qpe/qpeapplication.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>

#include "myGtk.h"
#include "gameWidget.h"
#include "common.h"
#include "thinkobj.h"
#include "status.h"


#define TITLE_POSX     100
#define TITLE_POSY      70
#define COPYLIGT_POSX   50
#define COPYLIGT_POSY  320
#define MAN_POSX       170
#define MAN_POSY       100
#define COM_POSX       170
#define COM_POSY       100
#define WIN_POSX       220
#define WIN_POSY       100

#define RETRY_POSX     220
#define RETRY_POSY     100
#define YES_POSX       230
#define YES_POSY       170
#define NO_POSX        350
#define NO_POSY        170

#define MESSAGE_POSX    220
#define MESSAGE_POSY    100

#define PLAYERNUM_POSX 530
#define PLAYERNUM_POSY 10
#define WINNER_POSX    210
#define WINNER_POSY    100

#define ENEMY_POSX     210
#define ENEMY_POSY     330

#define TIME_POSX       20
#define TIME_POSY      330
#define TURN_POSX       20
#define TURN_POSY      380
#define TURN_NUM_POSX   110
#define TURN_NUM_POSY   380
#define TIME_NUM_POSX  110
#define TIME_NUM_POSY  330


CGameWidget::CGameWidget(QWidget *parent, const char *name, WFlags f) :
    QWidget(parent, name, f)
{

#if defined(QT_THREAD_SUPPORT)
    //123
#endif

    m_thinking = 0;

    CImageLoader imgloader;

    m_timer = new QTimer(this);
    //STS_setStatus(TITLE);
    STS_initStatus();
    m_pixmap = 0;

    /* load image datas */
    imgloader.LoadImage(&m_titleImg[0],TITLE_IMG);
    imgloader.LoadImage(&m_titleImg[1],LOGO2_IMG);
    imgloader.LoadImage(&m_mode[0],SINGLE_IMG);
    imgloader.LoadImage(&m_mode[1],VS_IMG);
    
    imgloader.LoadImage(&m_blockImg[0],BLOCK01_IMG);
    imgloader.LoadImage(&m_blockImg[1],BLOCK02_IMG);

    imgloader.LoadImage(&m_backImg,BACK_IMG);
    imgloader.LoadImage(&m_thinkImg,THINKNOW_IMG);

    // 
    imgloader.LoadImage(&m_message[0],YOUWIN_IMG);
    imgloader.LoadImage(&m_message[1],YOULOST_IMG);
    imgloader.LoadImage(&m_message[2],WIN1_IMG);
    imgloader.LoadImage(&m_message[3],WIN2_IMG);
    imgloader.LoadImage(&m_message[4],DRAWGAME_IMG);

    //retry,yse,no
    imgloader.LoadImage(&m_retryImg,RETRY_IMG);
    imgloader.LoadImage(&m_slectImg[0],YES_IMG);
    imgloader.LoadImage(&m_slectImg[1],NO_IMG);  

    //
    imgloader.LoadImage(&m_attackImg[0],P_ATTACK_IMG);
    imgloader.LoadImage(&m_attackImg[1],A_ATTACK_IMG);

    // create game select button
    m_singlebtn = new CButton(&m_mode[0], 250, 240);
    m_vsbtn = new CButton(&m_mode[1], 270, 290);

    m_yesbtn = new CButton(&m_slectImg[0], YES_POSX, YES_POSY);
    m_nobtn  = new CButton(&m_slectImg[1], NO_POSX, NO_POSY);

    // init Enemy
    initEnemy(&imgloader);

    //
    m_selecter = new CSelecter(m_enemy);

    connect(m_timer, SIGNAL(timeout()), this, SLOT(timerTick()));
    m_timer->start(100);

}
CGameWidget::~CGameWidget()
{

  delete m_singlebtn;
  delete m_vsbtn;
  delete m_yesbtn;
  delete m_nobtn;
  delete m_selecter;

}


void CGameWidget::timerTick(void)
{
   repaint(false);
}

void CGameWidget::paintEvent(QPaintEvent *event)
{
  paint();
}
void CGameWidget::resizeEvent(QResizeEvent *event)
{

    QWidget::resizeEvent(event);
    if (!m_pixmap || event->size() != event->oldSize()) {
        if (m_pixmap) {
            delete m_pixmap;
        }
        m_pixmap = new QPixmap(event->size().width(), event->size().height());
    }

}
void CGameWidget::mousePressEvent(QMouseEvent *event)
{
 
  int status ;
  int x;
  int y;

  status = STS_getStatus();
  x = event->x();
  y = event->y();

  switch(status){

  case TITLE:
    if(m_singlebtn->isOn(x, y)){

      // change Status
      STS_setStatus(SELECT_PLAYER);

    }else if(m_vsbtn->isOn(x, y) == 1){
      // change mode "VS game"
      STS_setGameMode(VSGAME);
      // change status "under play"
      STS_setStatus(UNDER_PLAY);
    }
    break;

  case SELECT_PLAYER:
    CEnemy *enemy;
    enemy = m_selecter->mousePressEvent(x,y);
    if(enemy){
      // set selected enemy
      m_selectedEnemy = enemy;
      // change mode "Single game"
      STS_setGameMode(SINGLE_GAME);
      // change status "under play"
      STS_setStatus(UNDER_PLAY);
    }
    break;

  case UNDER_PLAY:
    /*
     *   Under Play 
     */
    clickMatrix(x,y);
    break;

  default:
    break;
  }

}
/*
  Draw Title Logo
 */
void CGameWidget::setTitle(QPainter *paint)
{
  paint->drawPixmap(150, 50, m_titleImg[0]);
  paint->drawPixmap(130, 40, m_titleImg[1]);
}
/*
  Draw Title View
 */
void CGameWidget::drawTitle(QPainter *paint)
{
  
  int max_x = width();
  int max_y = height();

  QColor white(255,255,255);
  paint->setPen(white);
  paint->fillRect(0, 0, max_x, max_y,  white);

  setTitle(paint);
  m_singlebtn->draw(paint);
  m_vsbtn->draw(paint);

  QColor black(0,0,0);
  paint->setPen(black);
  paint->drawText( 110, 380, 
                   "(C)2000-2003 TAIGA YONEKURA ALL RIGHTS RESERVED" );
}
void CGameWidget::drawAllBlock(QPainter *paint)
{

  int i,j;

  /*
   * draw blocks
   */
  for(i = 1;i <= BLOCK_NUM_X;i++){/*x*/

    for(j = 1;j <= BLOCK_NUM_Y;j++){/*y*/

      if(matrixtbl[i+j*(BLOCK_NUM_X + 2)] == FIRST_PLAYER){
        paint->drawPixmap(
                        BLOCK_OFFSET_X + (i - 1) * BLOCK_SIZE,
                        BLOCK_OFFSET_Y + (j - 1) * BLOCK_SIZE,
                         m_blockImg[0]);
      } else if(matrixtbl[i+j*(BLOCK_NUM_X + 2)] == SECOND_PLAYER){
        paint->drawPixmap(
                        BLOCK_OFFSET_X + (i - 1) * BLOCK_SIZE,
                        BLOCK_OFFSET_Y + (j - 1) * BLOCK_SIZE,
                        m_blockImg[1]);
      }

    }

  }


}
void CGameWidget::paint(void)
{
  int sts;
  QPainter painter_pixmap(m_pixmap);
  QPainter painter_widget(this);

  // get current status
  sts = STS_getStatus();

  // select Draw function
  switch(sts){

  case TITLE:
    //view title
    drawTitle(&painter_pixmap);
    break;

  case SELECT_PLAYER:
    m_selecter->drawSelecter(&painter_pixmap);
    break;

  case UNDER_PLAY:
    // under play
    drawPlayField(&painter_pixmap);
    drawAllBlock(&painter_pixmap);
    drawDetail(&painter_pixmap,STS_getSubStatus());
    if(m_thinking){
      //under thinking CPU
      painter_pixmap.drawPixmap(MAN_POSX, MAN_POSY, m_thinkImg);
    }
    break;

  default:
    break;
  }

  painter_pixmap.flush();
  painter_widget.drawPixmap(0, 0, *m_pixmap);
}

void  CGameWidget::drawDetail(QPainter *paint,int substs)
{
  switch(substs){
  case P1_WIN:
    paint->drawPixmap(WIN_POSX, WIN_POSY, m_message[0]);
    break;

  case P2_WIN:
    paint->drawPixmap(WIN_POSX, WIN_POSY, m_message[1]);
    break;

  case VS_P1_WIN:
    /* player */
    paint->drawPixmap(MESSAGE_POSX, MESSAGE_POSY, m_message[2]);
    break;

  case VS_P2_WIN:
    /* player */
    paint->drawPixmap(MESSAGE_POSX, MESSAGE_POSY, m_message[3]);
 
    break;

  case RETRY:
    paint->drawPixmap(RETRY_POSX, RETRY_POSY, m_retryImg);
    m_yesbtn->draw(paint);
    m_nobtn->draw(paint);
    break;

  case DRAWGAME:
    paint->drawPixmap(MESSAGE_POSX, MESSAGE_POSY, m_message[4]);
    break;

  case TIME_OVER:
    /* Time out */


  default:
    break;
  }



}
void  CGameWidget::drawPlayField(QPainter *paint)
{
  int i;

  QColor back(0,0,0);
  paint->setPen(back);
  paint->drawPixmap(0, 0, m_backImg);

  for(i = 0;i <= BLOCK_NUM_X;i++){
    paint->drawLine(BLOCK_OFFSET_X + i * BLOCK_SIZE ,
		  BLOCK_OFFSET_Y,
		  BLOCK_OFFSET_X + i * BLOCK_SIZE ,
		  BLOCK_OFFSET_Y + BLOCK_NUM_Y * BLOCK_SIZE);
  }

  for(i = 0;i <= BLOCK_NUM_Y;i++){
    paint->drawLine(BLOCK_OFFSET_X,
		  BLOCK_OFFSET_Y + i * BLOCK_SIZE ,
		  BLOCK_OFFSET_X + BLOCK_NUM_X * BLOCK_SIZE,
		  BLOCK_OFFSET_Y + i * BLOCK_SIZE );
  }

  // draw Enemy
  if(STS_getGameMode() != VSGAME){

    QPixmap *img;
    img = m_selectedEnemy->getImage();
    paint->drawPixmap(530, 20, *img);

  } else {

    if(STS_getPlayer() == FIRST_PLAYER){
      paint->drawPixmap(PLAYERNUM_POSX, PLAYERNUM_POSY, m_attackImg[0]);
    } else {
      paint->drawPixmap(PLAYERNUM_POSX, PLAYERNUM_POSY, m_attackImg[1]);
    }

  }
}
/*
  Tap Handler
 */
void CGameWidget::clickMatrix(int x,int y)
{
  int posx;
  int posy;

  switch(STS_getSubStatus()){

  case NORMAL:
    // convert matrix index
    posx = (x - BLOCK_OFFSET_X)/BLOCK_SIZE + 1;
    posy = (y - BLOCK_OFFSET_Y)/BLOCK_SIZE + 1;

    if(STS_CheckSetable(posx,posy)){

      if(STS_clickMatrix(posx,posy)){

	// Let's Next TRUN !
	// this code only run Single Game
	m_thinking = 1;
	repaint(false);
	sleep(1);
	STS_ChangePlayer(posx,posy,m_selectedEnemy->getStrong());
	m_thinking = 0;

      }

    }
    repaint(false);
    break;

  case P1_WIN:
  case VS_P1_WIN:
  case VS_P2_WIN:
  case TIME_OVER:
  case P2_WIN:
  case DRAWGAME:
    STS_setSubStatus(RETRY);
    break;

  case RETRY:
    if(m_nobtn->isOn(x,y)){
      /* NO */
      STS_setStatus(TITLE);
    } else if(m_yesbtn->isOn(x,y)){
      /* YES */
      STS_setSubStatus(NORMAL);
    }
    break;

  default:
    break;
  }

}
void CGameWidget::run()
{
}
/*
  init Enemy
 */
void  CGameWidget::initEnemy(CImageLoader *pimgLoader)
{
  QPixmap *pix[CENEMY_IMGCNT];
  int i;

  // taku
  for(i = 0; i < CENEMY_IMGCNT;i++ ){
    pix[i] = new QPixmap();
  }

  pimgLoader->LoadImage(pix[0],TAKU01_IMG);
  pimgLoader->LoadImage(pix[1],TAKU02_IMG);
  pimgLoader->LoadImage(pix[2],TAKU04_IMG);

  m_enemy[1] = new CEnemy(3);
  m_enemy[1]->setImages(pix);

#if 0
  // pen
  for(i = 0; i < CENEMY_IMGCNT;i++ ){
    pix[i] = new QPixmap();
  }

  pimgLoader->LoadImage(pix[0],PEN01_IMG);
  pimgLoader->LoadImage(pix[1],PEN02_IMG);
  pimgLoader->LoadImage(pix[2],PEN04_IMG);

  m_enemy[1] = new CEnemy(4);
  m_enemy[1]->setImages(pix);
#endif

  // taiga
  for(i = 0; i < CENEMY_IMGCNT;i++ ){
    pix[i] = new QPixmap();
  }

  pimgLoader->LoadImage(pix[0],TAIGA01_IMG);
  pimgLoader->LoadImage(pix[1],TAIGA02_IMG);
  pimgLoader->LoadImage(pix[2],TAIGA04_IMG);

  m_enemy[0] = new CEnemy(4);
  m_enemy[0]->setImages(pix);

}
