/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "selecter.h"
#include "gameWidget.h"
#include "images/selectimg.c"

#define ENEMYIMG_POSX 130
#define MESGIMG_POSX  130
#define MESGIMG_POSY  10

CSelecter::CSelecter(CEnemy *enemy[])
{
  int i;
  
  for(i = 0;i < 2;i++){
    m_enemy[i] = enemy[i];
  }

  m_enemyBtn[0] = new CButton(m_enemy[0]->getNormalImage(), 
			      ENEMYIMG_POSX, 100);
  m_enemyBtn[1] = new CButton(m_enemy[1]->getNormalImage(), 
			      ENEMYIMG_POSX, 210);
//  m_enemyBtn[2] = new CButton(m_enemy[2]->getNormalImage(), 110, 320);

  m_msgimg.loadFromData(selectmsg_data_, sizeof(selectmsg_data_));
  m_starimg.loadFromData(star_data_, sizeof(star_data_));
  m_levelimg.loadFromData(level_data_,sizeof(level_data_));
}
/*
    Draw Selecter View
 */
void CSelecter::drawSelecter(QPainter *paint)
{

  int i;
  QColor back(255,206,253);

  paint->fillRect(0, 0, SCREENW, SCREENH,  back);

  for(i = 0; i < ENEMY_COUNT; i++){
     m_enemyBtn[i]->draw(paint);
     paint->drawPixmap(m_enemyBtn[i]->getPosX() + 130,m_enemyBtn[i]->getPosY(),
		       m_levelimg);
     drawStar(m_enemyBtn[i]->getPosX() + 130 +85,m_enemyBtn[i]->getPosY()+10,
	      2-i,paint);
  }

  paint->drawPixmap(MESGIMG_POSX, MESGIMG_POSY, m_msgimg);

}
/*
  check Tap Enemy Image
 */
CEnemy* CSelecter::mousePressEvent(int x, int y)
{

  CEnemy *ret = NULL;
  int i;

  for(i = 0; i < ENEMY_COUNT; i++){

    if(m_enemyBtn[i]->isOn(x, y) == 1){
      ret = m_enemy[i];
      break;
    }

  }

  return ret;
 
}
/*
  draw strong stars
 */
void CSelecter::drawStar(int x,int y,int count,QPainter *paint)
{

  int i;

  for(i = 0; i < count; i++){
    paint->drawPixmap(x+i*20,y,m_starimg);
  }
}
