/*
  Copyright (C) 2000-2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
//#include <gtk/gtk.h>

#include "./common.h"
#include "./status_str.h"
#include "./thinkobj.h"
#include "./opelate.h"

static Status status;
static MtrxLinkNode *thinkstart;   /* */
gchar matrixtbl[(BLOCK_NUM_X + 2)*(BLOCK_NUM_Y + 2)];


void STS_initStatus()
{
  status.GameMode   = 0;
  status.GameStatus = TITLE;
  status.GsubStatus = NORMAL;
  status.turn       = 0;
  status.maxtime    = 300;            // thinking time 30sec
  status.player     = FIRST_PLAYER;
  status.score      = 0;
  status.prevalue   = 0;
  status.thinktime  = status.maxtime; //

  thinkstart = 0;

  // clear matrixtbl
  THK_ClearMtrxTbl(matrixtbl);
    
}


void STS_releaseSRC()
{
  OPE_FreeNode(thinkstart);
  thinkstart = NULL;
}

gint STS_getTurn(void)
{
  return status.turn;
}

gint STS_getTime(void)
{
  return status.thinktime;
}

void STS_decTime()
{
  status.thinktime--;
}

void STS_Setmatrixtbl(gint x,gint y,gint type)
{
  matrixtbl[x + y * (BLOCK_NUM_X + 2)] = type;
}


MtrxLinkNode** STS_GetStartPoint()
{
  return &thinkstart;
}


void sts_changeTurn()
{

  if(status.GameMode == VSGAME){

    /* VS MAN GAME */
    if(THK_valuVSmode(matrixtbl)){
      /*  */
      if(status.player == FIRST_PLAYER){
	status.GsubStatus = VS_P1_WIN;
      } else {
	status.GsubStatus = VS_P2_WIN;
      }

    }else {
      /*       */
      if(status.player == FIRST_PLAYER){
	status.player = SECOND_PLAYER;
      } else {
	status.player = FIRST_PLAYER;
	status.turn++;
      }

      status.thinktime = status.maxtime;/*a*/
    }

  } else {
    /* COM GAME */
    if(status.player == FIRST_PLAYER){
      /*  */
      if((thinkstart!=NULL) && THK_CheckValue(&(thinkstart->valueobj))){
	//  Win COM
	status.GsubStatus = P1_WIN;
	//
	STS_releaseSRC();
      } else {
	/*  */
	status.player = SECOND_PLAYER;
      }
    } else {
      /*  */

      /*  */
      THK_NextAttack(thinkstart);

      if(THK_CheckValue(&(thinkstart->valueobj))){
	/*  */
	status.GsubStatus = P2_WIN;
	/*  */
	STS_releaseSRC();
      } else {
	/*  */
	status.player = FIRST_PLAYER;
	status.turn++;
        status.thinktime = status.maxtime;
      }

    }
  }
  
  // check draw game
  if( (status.GsubStatus == NORMAL) 
      && (status.turn == (BLOCK_NUM_X * BLOCK_NUM_Y) / 2) ){
    
    // change status
    status.GsubStatus = DRAWGAME;

    // relese resources
    STS_releaseSRC();
  }

}
/*
 * Get status
 */
gint STS_getSubStatus()
{
  return status.GsubStatus;
}
/*
 * Change status
 */
void STS_setSubStatus(gint substatus)
{

  switch(substatus){
  case NORMAL:
    // clear matrixtbl
    THK_ClearMtrxTbl(matrixtbl);
    STS_releaseSRC();
    status.player = FIRST_PLAYER;
    status.turn   = 0;
    status.thinktime = status.maxtime;
    break;

  default:
    break;

  }

  status.GsubStatus = substatus;
}

gint STS_getStatus(void)
{
  return status.GameStatus;
}

gint STS_getPlayer()
{
  return status.player;
}

void STS_setStatus(gint sts)
{

  switch(sts){

  case TITLE:
    STS_initStatus();
    break;

  case UNDER_PLAY:
    STS_setSubStatus(NORMAL);
    break;

  default:
    break;
  }

  status.GameStatus = sts;
}

//int STS_clickMatrix(gint x,gint y,gint strong)
int STS_clickMatrix(gint x,gint y)
{
  int ret = 0;

  switch(status.GameMode){

  case SINGLE_GAME:
    if(status.GameStatus == FIRST_PLAYER){
      /*  */
      if(THK_CheckSetable(x,y,matrixtbl)){
	/* OK */
      
	*(matrixtbl+x+y*(BLOCK_NUM_X+2)) = status.player;

	/* COM GAME */
	OPE_DeleteTop(&thinkstart,x,y);

	sts_changeTurn(); /*  */
	if(status.GsubStatus == NORMAL){
	  ret = 1; 
	}

#if 0	
       	if(status.GsubStatus == NORMAL){
	  /*  */
	  THK_main(x,y,strong);
	  sts_changeTurn(); /*  */
	}
#endif


      }

    } else {
      /* NG */
      ;
    }
    break;

  case VSGAME:
       if(THK_CheckSetable(x,y,matrixtbl)){
	/* OK */
	*(matrixtbl+x+y*(BLOCK_NUM_X+2)) = status.player;  
	sts_changeTurn();
       }
       break;
  }

  return ret;

}
void STS_ChangePlayer(gint x,gint y,gint strong)
{
  if(status.GameMode == SINGLE_GAME){

    if(status.GsubStatus == NORMAL){
      /*  */
      THK_main(x,y,strong);
      sts_changeTurn(); /*  */
    }
  }

}
gboolean STS_CheckSetable(gint x,gint y)
{
  return THK_CheckSetable(x,y,matrixtbl);
}

gint STS_getGameMode(void)
{
  return status.GameMode;
}

void STS_setGameMode(gint mode)
{
  status.GameMode = mode;
}

void STS_timeout(void)
{
      /* time out */
      STS_setSubStatus(TIME_OVER);

      if(status.GameMode == VSGAME){
	// VS mode
        if(status.player == FIRST_PLAYER){
	  // win player2
	  status.GsubStatus = VS_P2_WIN;
        } else {
	  // win player1
	  status.GsubStatus = VS_P1_WIN;
        }
     }

}






