/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "CSchoolData.h"

CSchoolData::CSchoolData()
{
  m_BarthYear   = SYOWAYEAR;
  m_BatrhMonth  = 1;
  m_FinalSchool = COLLEGE;
  m_FailYear = 0;
  m_StayYear = 0;
  
  //TO DO
  /*
  makeSchoolCareer();
  loadData();
  */
}


/*
 *  Convert Japanese Year
 */
int CSchoolData::convertToJapnYear(int year)
{

  int width;
  int jpstarttbl[2] = {SYOWAYEAR,HEISEIYERA};
  
  if(year < jpstarttbl[0]) {
    /* before syowa */
    return 0;
  }
		
  width = year - jpstarttbl[1];
  if(width >= 0){
    /* year is Heisei */
    return width + 1;
  }
  
  /* year is Shyouwa */
  width = year - jpstarttbl[0];

  return width + 1;
}
/*
 *  Convert dominical year
 */
int CSchoolData::convertToYear(int yearType,int jpyear)
{
  int ret = 0;
  int jpstarttbl[2] = {SYOWAYEAR,HEISEIYERA};

  switch(yearType){

  case SYOUWA:
    ret = jpstarttbl[0] + jpyear - 1;
    break;

  case HEISEI:
    ret = jpstarttbl[1] + jpyear - 1;
    break;

  }
	
  return ret;
}
/*
 *  Check Syowa year
 */
boolean CSchoolData:: chkSyowa(int year)
{
  int width;
  int jpstarttbl[2] = {SYOWAYEAR,HEISEIYERA};

  if(year < jpstarttbl[0]) {
    /* before syowa */
    return false;
  }

  width = year - jpstarttbl[1];
  if(width >= 0){
    /* heisei */
    return false;
  }
		
  /* showa */
  return true;
}
/*
 *  Check Heisei year
 */
boolean CSchoolData::chkHeisei(int year)
{
  int width;
  int jpstarttbl = HEISEIYERA;
	
  if(chkSyowa(year)){
    /* syowa */
    return false;
  }

  width = year - jpstarttbl;
  if(width >= 0){
    /* heisei */
    return true;
  }
	
  return false;
}
void CSchoolData::makeSchoolCareer()
{
  int i;

  for(i=0;i<10;i++){
    schcareerYear[i] = 0;
  }

  schcareerYear[0] = m_BarthYear + 7;
  schcareerYear[1] = schcareerYear[0] + SCHOOLYEAR;

  schcareerYear[2] = schcareerYear[1];
  schcareerYear[3] = schcareerYear[2] + JRSCHOOLYEAR;

  schcareerYear[4] = schcareerYear[3];
  schcareerYear[5] = schcareerYear[3] + HISCHOOLYEAR;
		
  schcareerYear[6] = schcareerYear[5] + m_FailYear;
  if(m_FinalSchool == SHORTCOLLEGE){
    /* */
    schcareerYear[7] = schcareerYear[6] + m_StayYear + SCOLSCHOOLYEAR;
  } else {
    schcareerYear[7] = schcareerYear[6] + m_StayYear + COLSCHOOLYEAR;
  }

  schcareerYear[8] = schcareerYear[7];
  schcareerYear[9] = schcareerYear[8] + MASTERYEAR;
		
  if(m_BatrhMonth < 4){
    //
    for(i = 0;i < 10;i++){
      schcareerYear[i]--;
    }
  }
}	
/*
 *  get or set Methods of this class.
 */
void CSchoolData::SetBarthDay(int year,int month)
{

  boolean chk = false;

  if(year > 0){
    chk = true;
  }

  if(chk == true){
    chk = false;
    if((month > 0) && (month < 13)){
      chk = true;
    }
  }

  if(chk == true){
    m_BarthYear =  year;
    m_BatrhMonth = month;
  }
}
void CSchoolData::setFinalSchool(int type)
{
  if((type >= JRHISCHOORL) && (type <= MASTERCOLLEGE)){
    m_FinalSchool = type;
  }
}
void CSchoolData::setFailYear(int year)
{
  m_FailYear = year;
}
int CSchoolData::getBarthYear()
{
  return m_BarthYear;
}
int CSchoolData::getBarthMonth()
{
  return m_BatrhMonth;
}
int CSchoolData::getFailYear()
{
  return m_FailYear;
}
void CSchoolData::setStayYear(int year)
{
  m_StayYear = year;
}
int CSchoolData::getStayYear()
{
  return m_StayYear;
}
int CSchoolData::getFinalSchool()
{
  return m_FinalSchool;
}
int CSchoolData::getSchoolEntryYear()
{
  return schcareerYear[0];
}		
int CSchoolData::getSchoolGraduYear()
{
  return schcareerYear[1];
}		
int CSchoolData::getJrSchoolEntryYear()
{
  return schcareerYear[2];
}		
int CSchoolData::getJrSchoolGraduYear()
{
  return schcareerYear[3];
}	
int CSchoolData::getHiSchoolEntryYear()
{
  return schcareerYear[4];
}
int CSchoolData::getHiSchoolGraduYear()
{
  return schcareerYear[5];
}	
int CSchoolData::getClgSchoolEntryYear()
{
  return schcareerYear[6];
}
int CSchoolData::getClgSchoolGraduYear()
{
  return schcareerYear[7];
}	
int CSchoolData::getMasSchoolEntryYear()
{
  return schcareerYear[8];
}
int CSchoolData::getMasSchoolGraduYear()
{
  return schcareerYear[9];
}
//
//
//
int CSchoolData::Save(QFile *pFile)
{

  if(! pFile->writeBlock ( (char *)&m_BarthYear , sizeof(m_BarthYear)) ){
    return -1;
  }
  
  if(! pFile->writeBlock ( (char *)&m_BatrhMonth , sizeof(m_BatrhMonth)) ){
    return -1;
  }
  
  if(! pFile->writeBlock ( (char *)&m_FinalSchool , sizeof(m_FinalSchool)) ){
    return -1;
  }
  
  if(! pFile->writeBlock ( (char *)&m_FailYear , sizeof(m_FailYear)) ){
    return -1;
  }
  
  if(! pFile->writeBlock ( (char *)&m_StayYear , sizeof(m_StayYear)) ){
    return -1;
  }
  

  return 0;

}	
//
//
//
int CSchoolData::Load(QFile *pFile)
{

  int BarthYear;
  int BatrhMonth;
  int FinalSchool;
  int FailYear;
  int StayYear;

  if(pFile->readBlock ( (char *)&BarthYear , sizeof(BarthYear)) == -1){
    return -1;
  }
  if(pFile->readBlock ( (char *)&BatrhMonth , sizeof(BatrhMonth)) == -1){
    return -1;
  }
  if(pFile->readBlock ( (char *)&FinalSchool , sizeof(FinalSchool)) == -1){
    return -1;
  }
  if(pFile->readBlock ( (char *)&FailYear , sizeof(FailYear)) == -1){
    return -1;
  }
  if(pFile->readBlock ( (char *)&StayYear , sizeof(StayYear)) == -1){
    return -1;
  }

  m_BarthYear   = BarthYear;
  m_BatrhMonth  = BatrhMonth;
  m_FinalSchool = FinalSchool;
  m_FailYear = FailYear;
  m_StayYear = StayYear;

  return 0;

}
