/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef SCHOOLDATA_H
#define SCHOOLDATA_H

#define SYOWAYEAR  1926
#define HEISEIYERA 1989
#define SYOUWA 0
#define HEISEI 1

#define JRHISCHOORL    0
#define HISCHOORL      1
#define COLLEGE        2
#define SHORTCOLLEGE   3
#define MASTERCOLLEGE  4
	
/* year */
#define SCHOOLYEAR     6
#define JRSCHOOLYEAR   3
#define HISCHOOLYEAR   3
#define COLSCHOOLYEAR  4
#define SCOLSCHOOLYEAR 2
#define MASTERYEAR     2

#include <qfile.h>

typedef char boolean;

class CSchoolData {

 private:
  int m_BarthYear;
  int m_BatrhMonth;
  int m_FinalSchool;
  int m_FailYear;   //The year that try to enter college
  int m_StayYear;   //The over year of college 

  int schcareerYear[10]; //

 public:
  CSchoolData();
  int convertToJapnYear(int year);
  int convertToYear(int yearType,int jpyear);
  boolean chkSyowa(int year);
  boolean chkHeisei(int year);
  void makeSchoolCareer();

  void SetBarthDay(int year,int month);
  void setFinalSchool(int type);
  int getBarthYear();
  int getBarthMonth();
  int getFailYear();
  int getStayYear();
  int getFinalSchool();

  int getSchoolEntryYear();
  int getSchoolGraduYear();
  int getJrSchoolEntryYear();
  int getJrSchoolGraduYear();
  int getHiSchoolEntryYear();
  int getHiSchoolGraduYear();
  int getClgSchoolEntryYear();
  int getClgSchoolGraduYear();
  int getMasSchoolEntryYear();
  int getMasSchoolGraduYear();

  void setFailYear(int year);
  void setStayYear(int year);

  int Save(QFile *pFile);
  int Load(QFile *pFile);
};

#endif
