/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qlistbox.h>
#include <qpushbutton.h>

#include "SchoolCareerDlg.h"
#include "StringTable.h"

#define ELEMNT_START_STR STRING_UTF8(ID_STRING_2000)
#define ELEMNT_END_STR   STRING_UTF8(ID_STRING_2001)
#define JR_START_STR     STRING_UTF8(ID_STRING_2002)
#define JR_END_STR       STRING_UTF8(ID_STRING_2003)
#define HI_START_STR     STRING_UTF8(ID_STRING_2004)
#define HI_END_STR       STRING_UTF8(ID_STRING_2005)
#define CLG_START_STR    STRING_UTF8(ID_STRING_2006)
#define CLG_END_STR      STRING_UTF8(ID_STRING_2007)
#define SCLG_START_STR   STRING_UTF8(ID_STRING_2008)
#define SCLG_END_STR     STRING_UTF8(ID_STRING_2009)
#define MAS_START_STR    STRING_UTF8(ID_STRING_2010)
#define MAS_END_STR      STRING_UTF8(ID_STRING_2011)

#define HEISEI_STR STRING_UTF8(ID_STRING_2012)
#define SYOUWA_STR STRING_UTF8(ID_STRING_2013)

CSchoolCareerDlg::CSchoolCareerDlg(QWidget* parent, const char* name, WFlags fl)
  :CSchoolCareerDlgBase( parent, name, fl )
{
  connect( BackBtn, SIGNAL(clicked()), this, SLOT(exitDlg()) );
  setCaption( STRING_UTF8(ID_STRING_2014) );
}
void CSchoolCareerDlg::setSchoolData(CSchoolData* schoolData)
{
  m_pschoolData = schoolData;
  m_pschoolData->makeSchoolCareer();
  createViewSchool();
}
void CSchoolCareerDlg::createViewSchool()
{
  QString str;
  QString num;
  int year;

  /* enter elementary school  */
  year =  m_pschoolData->getSchoolEntryYear();
  str = createList(year, ELEMNT_START_STR);
  SchoolCareerList->insertItem(str);

  /* graduate  elementary school */
  year =  m_pschoolData->getSchoolGraduYear();
  str = createList(year, ELEMNT_END_STR);
  SchoolCareerList->insertItem(str);

  /* enter jr-hi school */
  year =  m_pschoolData->getJrSchoolEntryYear();
  str = createList(year, JR_START_STR);
  SchoolCareerList->insertItem(str);

  /* graduate jr-hi school */
  year =  m_pschoolData->getJrSchoolGraduYear();
  str = createList(year, JR_END_STR);
  SchoolCareerList->insertItem(str);

  /**/
  if( m_pschoolData->getFinalSchool() > JRHISCHOORL){
    /* enter hi school */
    year = m_pschoolData->getHiSchoolEntryYear();
    str = createList(year, HI_START_STR);
    SchoolCareerList->insertItem(str);

    /*  graduate hi school */
    year = m_pschoolData->getHiSchoolGraduYear();
    str = createList(year, HI_END_STR);
    SchoolCareerList->insertItem(str);

    if( m_pschoolData->getFinalSchool() > HISCHOORL){
      /**/
      year =  m_pschoolData->getClgSchoolEntryYear();
      str = createList(year, CLG_START_STR);
      SchoolCareerList->insertItem(str);

      year =  m_pschoolData->getClgSchoolGraduYear();
      str = createList(year, CLG_END_STR);
      SchoolCareerList->insertItem(str);
    }

    if( m_pschoolData->getFinalSchool() >= MASTERCOLLEGE){
      /**/
      year =  m_pschoolData->getMasSchoolEntryYear();
      str = createList(year, MAS_START_STR);
      SchoolCareerList->insertItem(str);
     
      year =  m_pschoolData->getMasSchoolGraduYear();
      str = createList(year, MAS_END_STR);
      SchoolCareerList->insertItem(str);
    }
  }

}
/*
 * type true:Japanese Year
 */
QString CSchoolCareerDlg::setDispString(int year,QString str,boolean type)
{
  QString retStr;
  QString numStr;
		
  if(type == true){
    if(m_pschoolData->chkSyowa(year) == true){
      retStr = SYOUWA_STR;
    } else {
      retStr = HEISEI_STR;
    }
			
    year = m_pschoolData->convertToJapnYear(year);
    numStr.setNum(year,10);
			
    if(year < 10){
      retStr += "0" + numStr;
    } else {
      retStr += numStr;
    }
  } else {
    retStr = "'";
    year = year % 100;
    numStr.setNum(year,10);

    if(year < 10){
      retStr = "0" + numStr;
    } else {
      retStr += numStr;
    }
  }
  return retStr + STRING_UTF8(ID_STRING_2015) + ":" + str;
		
}
/*
 *  create dispay string
 */
QString CSchoolCareerDlg::createList(int year, QString title )
{
  QString str;

  str.setNum(year,10);
  str += ":";
  str += setDispString(year,title,true);

  return str;
}
void CSchoolCareerDlg::exitDlg()
{
  close();
}
