/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#ifndef __SHISENSHO_HEADER__
#define __SHISENSHO_HEADER__

#include <qpe/qpemenubar.h>
#include <qmainwindow.h>
#include <qpopupmenu.h>
#include "Board.h"
#include "Status.h"
#include "ConfigInfo.h"

class ShisenSho : public QMainWindow
{
    Q_OBJECT

public:
    ShisenSho(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
    ~ShisenSho();

private:
    void readConfig(void);
    void writeConfig(void);
    void disableItems(void);

private:
    Board *m_board;
    CStatus *m_Status;
    CConfigInfo *m_ConfigInfo;
    QPopupMenu *m_gameMenu;
    QPopupMenu *m_speedMenu;
    QPopupMenu *m_sizeMenu;
    QPopupMenu *m_iqMenu;
    QPopupMenu *m_gravityMenu;
    QPopupMenu *m_configMenu;
    int m_speed;
    int m_size;
    int m_iq;
    int m_gravity;
    int m_idNewgame;
    int m_idGiveUp;
    int m_idHint;
    int m_idUndo;
    int m_idRedo;
    int m_idConfig;

protected slots:
    void updateSpeed(int speed);
    void updateSize(int size);
    void updateIQ(int iq);
    void updateGravity(int gravity);
    void start(void);
    void hint(void);
    void undo(void);
    void redo(void);
    void enableItems(void);
    void gameOver(void);
    void updateScore(void);
    void startGame(void);
    void changeConfig(void);
    void giveup(void);
};

#endif // __SHISENSHO_HEADER__

