/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#ifndef __SPRITECOLLECTION_HEADER__
#define __SPRITECOLLECTION_HEADER__

#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>

class SpriteCollection
{
public:
    SpriteCollection(QWidget *parent);

private:
    QPixmap m_tile[45];
    QPixmap m_button[3];
    QPixmap *m_background;
    QPixmap m_bootImg;
    QPixmap m_titleImg[3];
    QWidget *m_parent;

public:
    void drawTile(QPainter &painter, int x, int y, int which);
    QPixmap *backgroundPixmap(void);
    QPixmap *tilePixmap(int which);
    int tileWidth(void);
    int tileHeight(void);
    void drawBoot(QPainter &paint, int width, int height);
    void drawBoot(QPainter *paint, int width, int height);
    void drawTitle(QPainter &paint, int width, int height);
    QPixmap *buttonPixmap(int which);
};

#endif // __SPRITECOLLECTION_HEADER__

