/*
  Copyright (C) 2004  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "Status.h"

CStatus::CStatus()
{
  m_prestatus = STS_CLEAR;
  m_status = STS_UNDER_BOOT;
  m_counter = 4; //3sec
}
int CStatus::event(EVENT_TYPE evt)
{
  switch(m_status){

  case STS_UNDER_BOOT:

    if(evt == TIMEOUT){
      if(!m_counter--){
	changeStatus(STS_TITLE);
      }
    }
    break;

  case STS_TITLE:
    if(evt == PUSH_START){
      changeStatus(STS_REQSTART);
    }
    break;

  case STS_REQSTART:
    if(evt == SETUP_COMPLETED){
      changeStatus(STS_UNDERPLAY);
    }
    break;

  case STS_UNDERPLAY:
    if(evt == GIVEUP){
      changeStatus(STS_TITLE);
    }
    break;    
  }

  return m_status;
}
void CStatus::init()
{
  changeStatus(STS_UNDER_BOOT);
  m_counter = 4; //3sec
}
int CStatus::getStatus()
{
  return m_status;
}
void CStatus::changeStatus( int sts )
{
  m_prestatus = m_status;
  m_status = sts;
}
bool CStatus::isStatusChanged()
{
  if( m_status != m_prestatus ){
    return true;
  }

  return false;
}

bool CStatus::SyncStatus()
{
  bool ret = true;

  ret = isStatusChanged();
  m_prestatus = m_status;

  return ret;
}
