/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qcombobox.h>
#include <qgroupbox.h>

#include "ConfigDlg.h"
#include "StringTable.h"

CConfigDlg::CConfigDlg(QWidget* parent=0, const char* name=0, WFlags fl=0):ConfigDlgBase( parent, name, fl )
{

  setCaption( STRING_UTF8(ID_STRING_1000) );

  GroupBox->setTitle(STRING_UTF8(ID_STRING_1001));
  AnimeCmb->insertItem(STRING_UTF8(ID_STRING_1002));
  AnimeCmb->insertItem(STRING_UTF8(ID_STRING_1003));
  AnimeCmb->insertItem(STRING_UTF8(ID_STRING_1004));

}
int CConfigDlg::GetAnimation()
{
  
  return AnimeCmb->currentItem();

}
void CConfigDlg::setAnimation( int config )
{
  AnimeCmb->setCurrentItem(config);
}
