/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qfile.h>
#include "ConfigInfo.h"

#define CONFIG_FNAME ".mreversi/config.dat"

CConfigInfo::CConfigInfo()
{

  m_animationSpeed = CONFIG_FAST;
  ReadConfig();

}
int CConfigInfo::GetSpeed()
{
  return m_animationSpeed;
}
void CConfigInfo::SetSpeed( int speed )
{
  m_animationSpeed = speed;
  WriteConfig();
}
void CConfigInfo::ReadConfig()
{
  QFile file( CONFIG_FNAME );

  if( QFile::exists( CONFIG_FNAME ) ){
    // file exist
    file.open( IO_Raw | IO_ReadWrite );
    file.readBlock ( (char *)&m_animationSpeed, sizeof(int) );
    file.close();
  }  
  
}
void CConfigInfo::WriteConfig()
{

  QFile file( CONFIG_FNAME );

  if( QFile::exists( CONFIG_FNAME ) ){
    // file exist
    QFile::remove( CONFIG_FNAME );
  }
    
  file.open( IO_Raw | IO_ReadWrite );
  file.writeBlock ( (char *)&m_animationSpeed, sizeof(int) );
  file.close(); 

}
