/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qpe/qpemenubar.h>
#include <qpe/config.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <qpopupmenu.h>
#include <qtimer.h>
#include <stdlib.h>
#include <time.h>

#include "StringTable.h"
#include "MainWin.h"


CMainWin::CMainWin(QWidget *parent, const char *name, WFlags f) :
    QMainWindow(parent, name, f)
{

    bool vga = false;

    /* initialize random number generator */
    srand(::time(0));

    /* set font size */
    if( QString(getenv("QWS_DISPLAY")).find("Vga") >= 0 ){
      vga = true;
    }
    QFont f = QApplication::font();
    f.setPointSize( vga ? 18 : 10 );
    QApplication::setFont(f, true);

    /* set windows style and caption */
    setCaption(STRING_UTF8(ID_STRING_TITLE));

    /* create the play field as the central widget */
    m_game = new CGameWidget(this);
    setCentralWidget(m_game);
    m_game->show();


}
void CMainWin::closeEvent ( QCloseEvent *e )
{
  m_game->close();
  e->accept();
}

