/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#include <qwidget.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qpainter.h>
#include "SpriteCollection.h"
#include "config.h"
#include "images/commonImg.c"
#include "images/images.c"
#include "StringTable.h"
#include "CustomView.h"

#define BOOT_LOGOSTRING "PRESENTS"

SpriteCollection::SpriteCollection()
{

  m_BootLogBMP.loadFromData(BOOTLOGO_IMG_DATA, sizeof (BOOTLOGO_IMG_DATA));
  m_chip[0].loadFromData(chip_0_data_, sizeof (chip_0_data_));
  m_chip[1].loadFromData(chip_1_data_, sizeof (chip_1_data_));
  m_chip[2].loadFromData(chip_2_data_, sizeof (chip_2_data_));
  m_chip[3].loadFromData(chip_3_data_, sizeof (chip_3_data_));
  m_chip[4].loadFromData(chip_4_data_, sizeof (chip_4_data_));
  m_chip[5].loadFromData(chip_5_data_, sizeof (chip_5_data_));
  m_chip[6].loadFromData(chip_6_data_, sizeof (chip_6_data_));
  m_chip[7].loadFromData(chip_7_data_, sizeof (chip_7_data_));
  m_chip[8].loadFromData(chip_8_data_, sizeof (chip_8_data_));
  m_chip[9].loadFromData(chip_9_data_, sizeof (chip_9_data_));
  m_chip[10].loadFromData(chip_10_data_, sizeof (chip_10_data_));
  m_chip[11].loadFromData(chip_11_data_, sizeof (chip_11_data_));
  m_chip[12].loadFromData(chip_12_data_, sizeof (chip_12_data_));
  m_chip[13].loadFromData(chip_13_data_, sizeof (chip_13_data_));
  m_chip[14].loadFromData(chip_14_data_, sizeof (chip_14_data_));
  m_chip[15].loadFromData(chip_15_data_, sizeof (chip_15_data_));
  m_chip[16].loadFromData(chip_16_data_, sizeof (chip_16_data_));
  m_chip[17].loadFromData(chip_17_data_, sizeof (chip_17_data_));
  m_chip[18].loadFromData(chip_18_data_, sizeof (chip_18_data_));
  m_chip[19].loadFromData(chip_19_data_, sizeof (chip_19_data_));
  m_chip[20].loadFromData(chip_20_data_, sizeof (chip_20_data_));
  m_chip[21].loadFromData(chip_21_data_, sizeof (chip_21_data_));
  m_chip[22].loadFromData(chip_22_data_, sizeof (chip_22_data_));
  m_chip[23].loadFromData(chip_23_data_, sizeof (chip_23_data_));
  m_chip[24].loadFromData(chip_24_data_, sizeof (chip_24_data_));
  
  m_panel.loadFromData(panel_data_, sizeof (panel_data_));
  m_fieldlogo.loadFromData(fieldlogo_data_, sizeof (fieldlogo_data_));
  m_frame[0].loadFromData(frame01_data_, sizeof (frame01_data_));
  m_frame[1].loadFromData(frame02_data_, sizeof (frame02_data_));
  m_frame[2].loadFromData(frame03_data_, sizeof (frame03_data_));
  m_frame[3].loadFromData(frame04_data_, sizeof (frame04_data_));
}

void SpriteCollection::drawChip(QPainter &painter, int x, int y, int state)
{
    if (state >= 0 && state <= 24) {
        painter.drawPixmap(x, y, m_chip[0]);
	painter.drawPixmap(x, y, m_chip[state]);
    }
}
QPixmap* SpriteCollection::GetPanelImg()
{
  return &m_panel;
}
//
// Draw Boot Logo
//
void SpriteCollection::DrawBootLogo( QPainter *paint, int width, int height )
{

  QColor white( 255, 255, 255 );
  QColor black(0,0,0);
  QString str = BOOT_LOGOSTRING;

  paint->fillRect( 0, 0, width, height, white );
  paint->drawPixmap( CCustomView::Center_x(&m_BootLogBMP),BOOT_LOGO_Y, 
		     m_BootLogBMP );

  paint->setPen( black );
  paint->drawText( CCustomView::Center_x(&str), BOOT_LOGOSTRING_Y, str );

}
void SpriteCollection::setBackGround(QPainter *paint, int width, int height )
{
  QColor black(0,0,0);
  paint->fillRect( 0, 0, width, height, black );
  paint->drawPixmap( PLAYFIELD_PLATE_POS_X, PLAYFIELD_PLATE_POS_Y, 
		     m_panel );
  paint->drawPixmap( PLAYFIELD_LOGO_POS_X, PLAYFIELD_LOGO_POS_Y, 
		     m_fieldlogo );

  int offset = m_frame[0].height() + 1;
  //top
  paint->drawPixmap( PLAYFIELD_POS_X - offset, PLAYFIELD_POS_Y - offset,
		     m_frame[0] );
  //left
  paint->drawPixmap( PLAYFIELD_POS_X - offset, PLAYFIELD_POS_Y - offset + m_frame[0].height(),
		     m_frame[2] );
  //
  paint->drawPixmap( PLAYFIELD_POS_X - offset, 
		     PLAYFIELD_POS_Y - offset + m_frame[0].height() + m_frame[2].height(),
		     m_frame[1] );
  //right
  paint->drawPixmap( PLAYFIELD_POS_X - offset + m_frame[0].width() - m_frame[3].width(), 
		     PLAYFIELD_POS_Y - offset + m_frame[0].height(),
		     m_frame[3] );

}
void SpriteCollection::setStrings(QPainter *paint, QString name,QString msg,
				  int bcnt, int wcnt)
{
  QString str;
  str = STRING_UTF8(ID_STRING_18)+QString::number( bcnt )+QString(" ");
  str += STRING_UTF8(ID_STRING_19)+QString::number( wcnt )+QString(" ");
  paint->drawText( PLAYFIELD_COUNT_POS_X, PLAYFIELD_COUNT_POS_Y, str );
  paint->drawText( PLAYFIELD_NAME_POS_X, PLAYFIELD_NAME_POS_Y, name );
  paint->drawText( PLAYFIELD_MSG_POS_X, PLAYFIELD_MSG_POS_Y,msg );


}
void SpriteCollection::drawGameOver(QPainter *paint, int width, int height )
{
  QColor white(255,255,255);
  paint->fillRect( 0, 0, width, height, white );
  paint->drawText( 100,100,"gameover");

}
QPixmap* SpriteCollection::GetChipImg( int index )
{
  return &m_chip[index];
}
