/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#ifndef __SPRITECOLLECTION_HEADER__
#define __SPRITECOLLECTION_HEADER__

#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>

class SpriteCollection
{
public:
  SpriteCollection();

private:
  QPixmap m_chip[25];
  QPixmap m_BootLogBMP;
  QPixmap m_panel;
  QPixmap m_fieldlogo;
  QPixmap m_frame[4];


public:
  void drawChip(QPainter &painter, int x, int y, int state);
  void DrawBootLogo( QPainter *paint, int width, int height );
  void setBackGround(QPainter *paint, int width, int height );
  void setStrings(QPainter *paint, QString name, QString msg,
		  int black, int white);
  void drawGameOver(QPainter *paint, int width, int height);
  QPixmap* GetPanelImg();
  QPixmap* GetChipImg(int index);

};

#endif // __SPRITECOLLECTION_HEADER__

