/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "TitleView.h"
#include "ConfigDlg.h"
#include "config.h"
#include "images/titleimg.c"

#define COPYLIGHT1 "(C) Taiga Yonekura 2005"
#define COPYLIGHT2 "This program is distributed under terms of"
#define COPYLIGHT3 "the GNU General Public License(GPL)."

CTitleView::CTitleView(QWidget *pMainWidget, int Animation )
{
  LoadImages();
  m_pButton[0] = new CButton( &m_titleBMP[2], 
			      STARTBTN_POSX, STARTBTN_POSY );
  m_pButton[1] = new CButton( &m_titleBMP[3], 
			      CONFIG_POSX, CONFIG_POSY );
  m_pButton[2] = new CButton( &m_titleBMP[4], 
			      VSBTN_POSX, VSBTN_POSY );

  m_pMainWidget = pMainWidget;
  m_Animation = Animation;

}
CTitleView::~CTitleView()
{
  delete m_pButton[0];
  delete m_pButton[1];
  delete m_pButton[2];
}
void CTitleView::LoadImages()
{
  m_titleBMP[0].loadFromData(LOGO_IMG_DATA, sizeof (LOGO_IMG_DATA));
  m_titleBMP[1].loadFromData(TITLE_IMG_DATA, sizeof (TITLE_IMG_DATA));
  m_titleBMP[2].loadFromData(STARTLOGO_IMG_DATA, sizeof (STARTLOGO_IMG_DATA));
  m_titleBMP[3].loadFromData(CONFIG_IMG_DATA, sizeof (CONFIG_IMG_DATA));
  m_titleBMP[4].loadFromData(VSGAME_IMG_DATA, sizeof (VSGAME_IMG_DATA));

  m_wall.loadFromData(wall_data_, sizeof (wall_data_));

}
void CTitleView::draw(QPainter *paint, int width, int height )
{

  QColor white(255,255,255);

  for( int i=0; i < height; i+=80 ){
    for( int j=0; j < width; j+=80 ){
      paint->drawPixmap( j, i, m_wall );
    }
  }

  paint->drawPixmap(LOGO_POSX,LOGO_POSY,m_titleBMP[0]);
  paint->drawPixmap(TITLE_POSX,TITLE_POSY,m_titleBMP[1]);
  m_pButton[0]->draw(paint);
  m_pButton[1]->draw(paint);
  m_pButton[2]->draw(paint);

  QString str;
  paint->setPen(white);

  str = COPYLIGHT1;
  paint->drawText( Center_x(&str), COPYLIGHT1_POSY, str );
  str = COPYLIGHT2;
  paint->drawText( Center_x(&str), COPYLIGHT2_POSY, str );
  str = COPYLIGHT3;
  paint->drawText( Center_x(&str), COPYLIGHT3_POSY, str );

}
int CTitleView::click( int x, int y )
{
  int ret = 0;

  if( m_pButton[0]->isOn( x, y ) ){
    ret = 1;
  }

  if( m_pButton[1]->isOn( x, y ) ){

    CConfigDlg win(m_pMainWidget, "Options", true);
    win.setAnimation(m_Animation);
    win.exec();
    m_Animation = win.GetAnimation();

  }

  if( m_pButton[2]->isOn( x, y ) ){
    ret = 2;
  }

  return ret;
}
int CTitleView::GetAnimation()
{
  return m_Animation;
}
