/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "achievement.h"
#define HISCORE_DATA_VER 1

CAchievement::CAchievement( QString scoreFile )
{

  m_version = HISCORE_DATA_VER;
  Init();
  m_scoreFile = scoreFile;

}

void CAchievement::Init()
{
  int i;

  for( i = 0 ; i < LEVEL_MAX; i++){
    m_result[i][0] = 0;
    m_result[i][1] = 0;
    m_result[i][2] = 0;
  }

}
bool CAchievement::SaveReslut()
{

  QFile file( m_scoreFile );

  if( QFile::exists( m_scoreFile ) ){
    // file exist
    QFile::remove(  m_scoreFile );
  }

  file.open( IO_Raw | IO_ReadWrite );

  // write data
  Save( &file );
  file.close();
  
  return TRUE;
}
void CAchievement::RegistReslut(int level, unsigned int win, unsigned int lost, unsigned int draw )
{

  if( level < LEVEL_MAX ){
   m_result[level][0] = win;
   m_result[level][1] = lost;
   m_result[level][2] = draw;
  }

}
//
// Download from file.
//
bool CAchievement::DownLoad()
{

  bool ret = true;
  QFile file( m_scoreFile );

  if(OpenDataFile(&file)){

    if( Load(&file) ){
      ret = false;
    }

    file.close();
  } else {
    ret = false;
  }

  return ret;

}
void CAchievement::Save(QFile *pFile)
{

  int i;
  QString str;
  int levelcnt = LEVEL_MAX;

  // write data ver
  if( !pFile->writeBlock ( (char *)&m_version, sizeof(int) ) ){
    pFile->close();
  }

  // write level count
  if( !pFile->writeBlock ( (char *)&levelcnt, sizeof(int) ) ){
    pFile->close();
  }

  // write data
  for(i = 0; i < levelcnt; i++){
    //count of win
    if( !pFile->writeBlock ( (char *)&m_result[i][0], sizeof(unsigned int) ) ){
      return;
    }
    // count of lost
    if( !pFile->writeBlock ( (char *)&m_result[i][1], sizeof(unsigned int) ) ){
      return;
    }
    // count of draw
    if( !pFile->writeBlock ( (char *)&m_result[i][2], sizeof(unsigned int) ) ){
      return;
    }    
  }  

}
//
// Loading Hi-score data
//
int CAchievement::Load(QFile *pFile)
{
  int levelcnt;
  int i;

  //check level count
  if( pFile->readBlock ( (char *)&levelcnt, sizeof(int) ) == -1){
    return -1;
  }
  if( levelcnt != LEVEL_MAX ){
    return -1;
  }

  for(i = 0; i < LEVEL_MAX; i++){

    if( pFile->readBlock ( (char *)&m_result[i][0], sizeof(unsigned int) ) == -1){
      return -1;
    }

    if( pFile->readBlock ((char *)&m_result[i][1], sizeof(unsigned int) ) == -1){
      return -1;
    }
    
    if( pFile->readBlock ((char *)&m_result[i][2], sizeof(unsigned int) ) == -1){
      return -1;
    }
  }

  return 0;


}
bool CAchievement::OpenDataFile(QFile *pFile)
{

  int version;

  if(!QFile::exists( m_scoreFile )){
      return false;
  }

  pFile->open(IO_ReadOnly);
  if(pFile->readBlock ( (char *)&version , sizeof(int)) == -1){
    pFile->close();
    return false;
  }

  if( version != m_version ){
    pFile->close();
    return false;
  }

  return true;

}
bool CAchievement::Get(int level, unsigned int* win, unsigned int* lost, unsigned int* draw)
{
  
  if( level < LEVEL_MAX ){
    *win = m_result[level][0];
    *lost = m_result[level][1];
    *draw = m_result[level][2];
    return true;
  }

  return false;
}
void CAchievement::Win(int level)
{
  if( level < LEVEL_MAX ){
    m_result[level][0]++;
  }  
}
void CAchievement::Lost(int level)
{
  if( level < LEVEL_MAX ){
    m_result[level][1]++;
  } 
}
