/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#define SCALE(x) (x/2)

#define SCREENW SCALE(480) // screen size
#define SCREENH SCALE(640) // 
#define SCREEN_HEGIHT_ADJUSTMENT SCALE(60)

#define TILE_SIZE SCALE(50)
#define PLAYFIELD_POS_X  SCALE(40)
#define PLAYFIELD_POS_Y SCALE(120)


//
// Image Data
//
#define BOOTLOGO_IMG_DATA   bootlogo_data_
#define TITLE_IMG_DATA title_data_
#define LOGO_IMG_DATA logo_data_
#define STARTLOGO_IMG_DATA startlogo_data_
#define CONFIG_IMG_DATA config_data_
#define VSGAME_IMG_DATA vsgame_data_

#define ENEMY01_IMG_DATA enemy0101_data_
#define ENEMY02_IMG_DATA enemy0201_data_
#define ENEMY03_IMG_DATA enemy0301_data_
#define ENEMY04_IMG_DATA enemy0401_data_
#define ENEMY05_IMG_DATA enemy0501_data_
#define ENEMYHIDDEN_IMG_DATA enemyhidden_data_

//
// Image Position
//
#define BOOT_LOGO_Y 100
#define BOOT_LOGOSTRING_Y 140

#define TITLE_POSX      SCALE(100)
#define TITLE_POSY      SCALE(120)
#define LOGO_POSX       SCALE(90)
#define LOGO_POSY       SCALE(80)
#define STARTBTN_POSX   SCALE(145)
#define STARTBTN_POSY   SCALE(360)
#define VSBTN_POSX      SCALE(245)
#define VSBTN_POSY      SCALE(360)
#define CONFIG_POSX     SCALE(200)
#define CONFIG_POSY     SCALE(410)
#define COPYLIGHT1_POSY SCALE(480)
#define COPYLIGHT2_POSY SCALE(520)
#define COPYLIGHT3_POSY SCALE(540)

//EnemySelectView
#define ENEMY_POS_X    SCALE(100)

#define ENEMY01_POS_X  ENEMY_POS_X
#define ENEMY01_POS_Y   SCALE(80)
#define ENEMY02_POS_X  ENEMY_POS_X
#define ENEMY02_POS_Y  SCALE(170)
#define ENEMY03_POS_X  ENEMY_POS_X
#define ENEMY03_POS_Y  SCALE(260)
#define ENEMY04_POS_X  ENEMY_POS_X
#define ENEMY04_POS_Y  SCALE(350)
#define ENEMY05_POS_X  ENEMY_POS_X
#define ENEMY05_POS_Y  SCALE(440)

#define ENMEY_PLATE_WIDTH  SCALE(300)
#define ENMEY_PLATE_HEIGHT  SCALE(70)

#define ENEMY_PLATE01_POS_X (ENEMY01_POS_X-2)
#define ENEMY_PLATE01_POS_Y (ENEMY01_POS_Y-2)
#define ENEMY_PLATE02_POS_X (ENEMY02_POS_X-2)
#define ENEMY_PLATE02_POS_Y (ENEMY02_POS_Y-2)
#define ENEMY_PLATE03_POS_X (ENEMY03_POS_X-2)
#define ENEMY_PLATE03_POS_Y (ENEMY03_POS_Y-2)
#define ENEMY_PLATE04_POS_X (ENEMY04_POS_X-2)
#define ENEMY_PLATE04_POS_Y (ENEMY04_POS_Y-2)
#define ENEMY_PLATE05_POS_X (ENEMY05_POS_X-2)
#define ENEMY_PLATE05_POS_Y (ENEMY05_POS_Y-2)

#define ENEMY_SELECT_POS_X   SCALE(120)
#define ENEMY_SELECT_POS_Y   SCALE(40)

#define ENEMY_TEXT_POS_OFFSET_X   SCALE(80)
#define ENEMY_NAME_POS_OFFSET_Y   SCALE(20)
#define ENEMY_MSG_POS_OFFSET_Y    SCALE(40)

#define ENEMY_RESULT01_POS_X   (ENEMY_PLATE01_POS_X+SCALE(80))
#define ENEMY_RESULT01_POS_Y   (ENEMY_PLATE01_POS_Y+SCALE(60))
#define ENEMY_RESULT02_POS_X   (ENEMY_PLATE02_POS_X+SCALE(80))
#define ENEMY_RESULT02_POS_Y   (ENEMY_PLATE02_POS_Y+SCALE(60))
#define ENEMY_RESULT03_POS_X   (ENEMY_PLATE03_POS_X+SCALE(80))
#define ENEMY_RESULT03_POS_Y   (ENEMY_PLATE03_POS_Y+SCALE(60))
#define ENEMY_RESULT04_POS_X   (ENEMY_PLATE04_POS_X+SCALE(80))
#define ENEMY_RESULT04_POS_Y   (ENEMY_PLATE04_POS_Y+SCALE(60))
#define ENEMY_RESULT05_POS_X   (ENEMY_PLATE05_POS_X+SCALE(80))
#define ENEMY_RESULT05_POS_Y   (ENEMY_PLATE05_POS_Y+SCALE(60))

//PlayField
#define PLAYFIELD_PLATE_POS_X SCALE(10)
#define PLAYFIELD_PLATE_POS_Y SCALE(10)
#define PLAYFIELD_ENEMY_POS_X SCALE(15)
#define PLAYFIELD_ENEMY_POS_Y SCALE(15)

#define PLAYFIELD_LOGO_POS_X SCALE(320)
#define PLAYFIELD_LOGO_POS_Y  SCALE(15) 
#define PLAYFIELD_NAME_POS_X SCALE(80)
#define PLAYFIELD_NAME_POS_Y SCALE(30)
#define PLAYFIELD_MSG_POS_X  SCALE(90)
#define PLAYFIELD_MSG_POS_Y  SCALE(52)
#define PLAYFIELD_COUNT_POS_X SCALE(90)
#define PLAYFIELD_COUNT_POS_Y SCALE(74)

//GameoverView
#define RESULT_POS_Y      SCALE(100)
#define RESULTENEMY_POS_Y SCALE(120)
#define STATE_POS_Y       SCALE(220)
#define YOURSCORE_POS_Y   SCALE(240)
#define ENEMYSCORE_POS_Y  SCALE(260)
#define RETURN_POS_Y      SCALE(400)
