/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "enemy.h"
#include "StringTable.h"

CEnemy::CEnemy( int strong, QString name )
{
  m_strong = strong;
  m_result[0] = 0;
  m_result[1] = 0;
  m_result[2] = 0;
  m_name = name;
  m_hidden = false;
  m_phiddenImg = 0;
}
int CEnemy::getStrong()
{
  return m_strong;
}
QString CEnemy::getName()
{

  if(m_hidden){
    return STRING_UTF8( ID_STRING_00 );
  }

  return m_name;
}
void CEnemy::setImages(QPixmap *img[])
{
  int i;

  for(i = 0; i< CENEMY_IMGCNT ;i++){
    m_Img[i] = img[i];
  }

}
void CEnemy::setImages(QPixmap *img)
{
    m_Img[0] = img;
}
QPixmap* CEnemy::getNormalImage()
{
  return m_Img[0];
}
QPixmap* CEnemy::getImage()
{

  if(m_hidden){
    return m_phiddenImg;
  }
  return m_Img[0];

}
void CEnemy::setResult(unsigned int win, unsigned int lost, unsigned int draw )
{
  m_result[0] = win;
  m_result[1] = lost;
  m_result[2] = draw;
}
void CEnemy::getResult(unsigned int* win, unsigned int* lost, unsigned int* draw)
{
  *win = m_result[0];
  *lost = m_result[1];
  *draw = m_result[2];
}
void CEnemy::win()
{
  m_result[0]++;
}
void CEnemy::lost()
{
  m_result[1]++;
}
void CEnemy::draw()
{
  m_result[2]++;
}
void CEnemy::setHiddenImages(QPixmap *img)
{
  m_phiddenImg = img;
}
void CEnemy::setHidden( bool hidden )
{
  m_hidden = hidden;
}
bool CEnemy::isHidden()
{
  return m_hidden;
}






