/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "enemyImgCollection.h"
#include "config.h"
#include "images/enemyimg.c"

CEnemyImgCollection::CEnemyImgCollection()
{
  LoadImages();
}
void CEnemyImgCollection::LoadImages()
{
  m_BMP[0].loadFromData(ENEMY01_IMG_DATA, sizeof (ENEMY01_IMG_DATA));
  m_BMP[1].loadFromData(ENEMY02_IMG_DATA, sizeof (ENEMY02_IMG_DATA));
  m_BMP[2].loadFromData(ENEMY03_IMG_DATA, sizeof (ENEMY03_IMG_DATA));
  m_BMP[3].loadFromData(ENEMY04_IMG_DATA, sizeof (ENEMY04_IMG_DATA));
  m_BMP[4].loadFromData(ENEMY05_IMG_DATA, sizeof (ENEMY05_IMG_DATA));
  m_BMP[5].loadFromData(ENEMYHIDDEN_IMG_DATA, sizeof (ENEMYHIDDEN_IMG_DATA));
}
QPixmap* CEnemyImgCollection::GetImg( int idx )
{
  return &m_BMP[idx];
}
