/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef __ENEMYIMMNG_HEADER__
#define __ENEMYIMMNG_HEADER__

#include "enemy.h"
#include "enemyImgCollection.h"
#include "achievement.h"

#define ENEMY_COUNT 5

class CEnemyMng
{

 public:
  CEnemyMng();
  ~CEnemyMng();
  CEnemy* GetEnemy( int type );
  CEnemy* GetSelectedEnemy();
  int GetEnemyCount();
  void SelectEnemy( int type );
  void SaveResult();
  int GetSelectEnemyType();

 private:
  CEnemyImgCollection m_ememyImg;
  CEnemy *m_pEnemy[ENEMY_COUNT];
  CAchievement *m_pAchieve;
  int  m_selected;
  void initEnemy();
  void initAchieve();
  bool isHidden();
  
};
#endif
