/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "enemySelectView.h"
#include "config.h"
#include "StringTable.h"

CEnemySelectView::CEnemySelectView( CEnemyMng *pEnemyMng, QPixmap* pPanel )
{
  m_pEmenyMng = pEnemyMng;
  m_pPanel = pPanel;
  m_pButton[0] = new CButton( m_pPanel, 
			      ENEMY_PLATE01_POS_X, ENEMY_PLATE01_POS_Y );
  if( m_pEmenyMng->GetEnemy(0)->isHidden() ){
    m_pButton[0]->disable();
  }

  m_pButton[1] = new CButton( m_pPanel,
			      ENEMY_PLATE02_POS_X, ENEMY_PLATE02_POS_Y );
  m_pButton[2] = new CButton( m_pPanel,
			      ENEMY_PLATE03_POS_X, ENEMY_PLATE03_POS_Y );
  m_pButton[3] = new CButton( m_pPanel,
			      ENEMY_PLATE04_POS_X, ENEMY_PLATE04_POS_Y );
  m_pButton[4] = new CButton( m_pPanel,
			      ENEMY_PLATE05_POS_X, ENEMY_PLATE05_POS_Y );

}
CEnemySelectView::~CEnemySelectView()
{
  for( int i = 0; i < ENEMY_BUTTON_NUM; i++ ){
    delete m_pButton[i];
  }
}
void CEnemySelectView::draw(QPainter *paint, int width, int height )
{
  QString msg;
  QColor black(0,0,0);
  QColor white(255,255,255);

  paint->fillRect( 0, 0, width, height, black );

  for( int i = 0; i < ENEMY_BUTTON_NUM; i++ ){
    m_pButton[i]->draw(paint);
  }
  paint->drawPixmap( ENEMY01_POS_X, ENEMY01_POS_Y,
		     *(m_pEmenyMng->GetEnemy(0))->getImage());
  paint->drawPixmap( ENEMY02_POS_X, ENEMY02_POS_Y,
		     *(m_pEmenyMng->GetEnemy(1))->getImage());
  paint->drawPixmap( ENEMY03_POS_X, ENEMY03_POS_Y,
		     *(m_pEmenyMng->GetEnemy(2))->getImage());
  paint->drawPixmap( ENEMY04_POS_X, ENEMY04_POS_Y,
		     *(m_pEmenyMng->GetEnemy(3))->getImage());
  paint->drawPixmap( ENEMY05_POS_X, ENEMY05_POS_Y,
		     *(m_pEmenyMng->GetEnemy(4))->getImage());

  // Tux
  paint->drawText( ENEMY_PLATE01_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE01_POS_Y + ENEMY_NAME_POS_OFFSET_Y,
		   (m_pEmenyMng->GetEnemy(0))->getName());
  msg = STRING_UTF8( ID_STRING_10 );
  paint->drawText( ENEMY_PLATE01_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE01_POS_Y + ENEMY_MSG_POS_OFFSET_Y, msg );  
  msg = CreateResultMsg(m_pEmenyMng->GetEnemy(0));
  paint->drawText( ENEMY_RESULT01_POS_X, ENEMY_RESULT01_POS_Y, msg );  

  // Hase
  paint->drawText( ENEMY_PLATE02_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE02_POS_Y + ENEMY_NAME_POS_OFFSET_Y,
		   (m_pEmenyMng->GetEnemy(1))->getName());
  msg = STRING_UTF8( ID_STRING_11 );
  paint->drawText( ENEMY_PLATE02_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE02_POS_Y + ENEMY_MSG_POS_OFFSET_Y, msg ); 
  msg = CreateResultMsg(m_pEmenyMng->GetEnemy(1));
  paint->drawText( ENEMY_RESULT02_POS_X, ENEMY_RESULT02_POS_Y, msg );

  // Kouji
  paint->drawText( ENEMY_PLATE03_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE03_POS_Y + ENEMY_NAME_POS_OFFSET_Y,
		   (m_pEmenyMng->GetEnemy(2))->getName());
  msg = STRING_UTF8( ID_STRING_12 );
  paint->drawText( ENEMY_PLATE03_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE03_POS_Y + ENEMY_MSG_POS_OFFSET_Y, msg ); 
  msg = CreateResultMsg(m_pEmenyMng->GetEnemy(2));
  paint->drawText( ENEMY_RESULT03_POS_X, ENEMY_RESULT03_POS_Y, msg );

  // Ken
  paint->drawText( ENEMY_PLATE04_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE04_POS_Y + ENEMY_NAME_POS_OFFSET_Y,
		   (m_pEmenyMng->GetEnemy(3))->getName());
  msg = STRING_UTF8( ID_STRING_13 );
  paint->drawText( ENEMY_PLATE04_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE04_POS_Y + ENEMY_MSG_POS_OFFSET_Y, msg ); 
  msg = CreateResultMsg(m_pEmenyMng->GetEnemy(3));
  paint->drawText( ENEMY_RESULT04_POS_X, ENEMY_RESULT04_POS_Y, msg );

  // Taiga
  paint->drawText( ENEMY_PLATE05_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE05_POS_Y + ENEMY_NAME_POS_OFFSET_Y,
		   (m_pEmenyMng->GetEnemy(4))->getName());
  msg = STRING_UTF8( ID_STRING_14 );
  paint->drawText( ENEMY_PLATE05_POS_X + ENEMY_TEXT_POS_OFFSET_X,
		   ENEMY_PLATE05_POS_Y + ENEMY_MSG_POS_OFFSET_Y, msg ); 
  msg = CreateResultMsg(m_pEmenyMng->GetEnemy(4));
  paint->drawText( ENEMY_RESULT05_POS_X, ENEMY_RESULT05_POS_Y, msg );

  paint->setPen(white);
  paint->drawText( ENEMY_SELECT_POS_X, ENEMY_SELECT_POS_Y,
		   STRING_UTF8( ID_STRING_21 ));   


}
int CEnemySelectView::click( int x, int y )
{
  int ret = 0;

  for( int i = 0; i < ENEMY_BUTTON_NUM; i++ ){
    if( m_pButton[i]->isOn( x, y ) ){
      ret = i + 1;
      m_pEmenyMng->SelectEnemy(i);
      break;
    }
  }

  return ret;
}
QString CEnemySelectView::CreateResultMsg( CEnemy *pEnemy )
{
  unsigned int win,lost,draw;
  QString msg;

  pEnemy->getResult( &win, &lost, &draw );
  msg = STRING_UTF8(ID_STRING_06)+QString::number( lost )+QString(" ");
  msg += STRING_UTF8(ID_STRING_07)+QString::number( win )+QString(" ");
  msg += STRING_UTF8(ID_STRING_08)+QString::number( draw );
  return msg;
  
}
