#!/bin/sh

VERSION=1.0.0

if [ "$1" = "sl700" ]; then
    ln -v -f -s config/config-sl700.h config.h
    lv -Ou8cp desktop/mreversi-sl700.desktop  > desktop/mreversi.desktop
    PACKAGE_FILE=mreversi_${VERSION}-sl700_arm.ipk
    cat > config.mk <<END
CONFIG_VGA=y    
END

elif [ "$1" = "sl300" ]; then
    ln -v -f -s config/config-sl300.h config.h
    lv -Ou8cp desktop/mreversi-sl300.desktop  > desktop/mreversi.desktop
    PACKAGE_FILE=mreversi_${VERSION}-sl300_arm.ipk
    cat > config.mk <<END
CONFIG_QVGA=y    
END

else
    echo "usage: $0 sl700 | sl300 cross | native"
    exit 1
fi

if [ "$2" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=arm
elif [ "$2" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=x86
else
    echo "usage: $0 cross | native"
    exit 1
fi

make -C tools
make -C images

tmake -o Makefile m-reversi.pro
make
lrelease m-reversi.pro

# make package tmp dir
TMPDIR=mreversi_1.0.0
mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p CONTROL
for LANGUAGE in en ja; do
    if [ "$LANGUAGE" != "en" ]; then
	mkdir -p opt/QtPalmtop/help/${LANGUAGE}/html
	mkdir -p opt/QtPalmtop/i18n/${LANGUAGE}
    else
	mkdir -p opt/QtPalmtop/help/html 
    fi
done

# copy files
cp ../desktop/mreversi.desktop opt/QtPalmtop/apps/Games
cp ../mreversi opt/QtPalmtop/bin
cp ../desktop/mreversi.png opt/QtPalmtop/pics
cp ../desktop/mreversi.control CONTROL/control
cp ../desktop/mreversi.prerm CONTROL/prerm

for LANGUAGE in en ja; do
    if [ "$LANGUAGE" = "en" ]; then
	cp ../desktop/mreversius.html opt/QtPalmtop/help/html/mreversi.html
    elif [ "$LANGUAGE" = "ja" ]; then
	lv -Ou8cp ../desktop/mreversijp.html  > opt/QtPalmtop/help/${LANGUAGE}/html/mreversi.html
	cp ../i18n/${LANGUAGE}/mreversi.qm opt/QtPalmtop/i18n/${LANGUAGE}
    fi
done

# package build
cd ..
ipkg-build ${TMPDIR}
mv mreversi_1.0.0_arm.ipk ${PACKAGE_FILE}
echo created package ${PACKAGE_FILE}
rm -rf ${TMPDIR}
