#!/bin/sh

VERSION=1.1.0

if [ "$1" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=arm
elif [ "$1" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=x86
else
    echo "usage: $0 cross | native"
    exit 1
fi

TMPDIR=m-shisensho_1.1.0

make -C tools
make -C images

lv -Ou8cp StringTable.rsc > StringTable.h

tmake -o Makefile shisensho.pro
make
#lrelease shisensho.pro

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL

lv -Ou8cp ../desktop/m-shisensho.desktop > opt/QtPalmtop/apps/Games/m-shisensho.desktop
cp ../m-shisensho opt/QtPalmtop/bin
cp ../desktop/m-shisensho.png opt/QtPalmtop/pics
lv -Ou8cp ../desktop/m-shisensho.html > opt/QtPalmtop/help/html/m-shisensho.html
cp ../desktop/m-shisensho.control CONTROL/control
cp ../desktop/m-shisensho.prerm CONTROL/prerm
cd ..
ipkg-build ${TMPDIR}
rm -rf ${TMPDIR}
