package org.dyndns.nuda.tools.regex.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.dyndns.nuda.tools.regex.util.FILTER_TIMING;

/**
 * このアノテーションが付与されたメソッドが指定された正規表現シーケンス のフィルタとして動作することを表します
 * 
 * @author koseki
 * 
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ProcessFilter {
	public int groupindex() default 0;

	public FILTER_TIMING timing() default FILTER_TIMING.BEFORE_COMMITED;

	public String[] include() default {""};

	public String[] exclude() default {""};
}
