package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;

public class StringInputSequenceProcessor implements InputSequenceProcessor {

	@Override
	public boolean accept(Field targetField, String inputSequence) {
		Class<?> targetClass = targetField.getType();
		if(String.class.equals(targetClass)) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void process(Field targetField, Object instance, String inputSequence) {
		try {
			//System.out.println("StringInputSequenceProcessor:process:by:" + instance.getClass() + ":" + targetField.getName() + ":" + inputSequence);
			targetField.set(instance, inputSequence);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}

}
