package org.dyndns.nuda.tools.regex.reflection.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dyndns.nuda.tools.regex.annotation.ProcessFilter;
import org.dyndns.nuda.tools.regex.util.FILTER_TIMING;

public class TargetMethodCache implements MethodCache {
	private static TargetMethodCache ME = null;

	private static Map<Class<?>, Map<Integer, List<Method>>> preCache = new HashMap<Class<?>, Map<Integer, List<Method>>>();
	private static Map<Class<?>, Map<Integer, List<Method>>> postCache = new HashMap<Class<?>, Map<Integer, List<Method>>>();

	private TargetMethodCache() {

	}

	public static TargetMethodCache getInstance() {
		if (ME == null) {
			ME = new TargetMethodCache();
		}

		return ME;
	}

	// ADD START n.koseki 2014/01/29 プロセスフィルタ対応

	/**
	 * 
	 * @param targetClass
	 * @return
	 */
	public Map<Integer, List<Method>> createPreProcessor(Class<?> targetClass) {
		Map<Integer, List<Method>> result = null;

		if (targetClass == null) {
			return result;
		}

		if (preCache.containsKey(targetClass)) {
			result = preCache.get(targetClass);
			return result;
		} else {
			result = new HashMap<Integer, List<Method>>();
			Method[] methods = targetClass.getDeclaredMethods();
			for (Method m : methods) {
				if (isValidFilter(m)) {
					ProcessFilter filter = m.getAnnotation(ProcessFilter.class);
					int groupindex = filter.groupindex();
					FILTER_TIMING timing = filter.timing();
					if (timing.equals(FILTER_TIMING.BEFORE_COMMITED)) {
						if (result.containsKey(groupindex)) {
							result.get(groupindex).add(m);
						} else {
							List<Method> l = new ArrayList<Method>();
							l.add(m);
							result.put(groupindex, l);
						}
					}
				}
			}
			preCache.put(targetClass, result);
		}

		return result;
	}

	/**
	 * 
	 * @param targetClass
	 * @return
	 */
	public Map<Integer, List<Method>> createPostProcessor(Class<?> targetClass) {
		Map<Integer, List<Method>> result = null;

		if (targetClass == null) {
			return result;
		}

		if (postCache.containsKey(targetClass)) {
			result = postCache.get(targetClass);
			return result;
		} else {
			result = new HashMap<Integer, List<Method>>();
			Method[] methods = targetClass.getDeclaredMethods();
			for (Method m : methods) {
				if (isValidFilter(m)) {
					ProcessFilter filter = m.getAnnotation(ProcessFilter.class);
					int groupindex = filter.groupindex();
					FILTER_TIMING timing = filter.timing();
					if (timing.equals(FILTER_TIMING.AFTER_COMMITED)) {
						if (result.containsKey(groupindex)) {
							result.get(groupindex).add(m);
						} else {
							List<Method> l = new ArrayList<Method>();
							l.add(m);
							result.put(groupindex, l);
						}
					}
				}
			}
			postCache.put(targetClass, result);
		}

		return result;
	}

	/**
	 * 
	 * @param method
	 * @return
	 */
	private boolean isValidFilter(Method method) {
		if (method == null) {
			return false;
		}
		if (!method.isAnnotationPresent(ProcessFilter.class)) {
			return false;
		}
		Class<?> returnType = method.getReturnType();
		Class<?>[] parameterTypes = method.getParameterTypes();

		if (!"java.lang.String".equals(returnType.getCanonicalName())) {
			return false;
		}
		if (parameterTypes.length != 1) {
			return false;
		}
		Class<?> parameterType = parameterTypes[0];
		if ("java.lang.String".equals(parameterType.getCanonicalName())) {
			return false;
		}

		return true;
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub
		
	}
	
	// ADD END n.koseki 2014/01/29 プロセスフィルタ対応
}
