package org.dyndns.nuda.tools.regex.util;

import java.util.regex.Pattern;

import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.reflection.cache.CacheManager;
import org.dyndns.nuda.tools.regex.reflection.cache.NoCachedRegexCache;
import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;
import org.dyndns.nuda.tools.util.StringUtil;

/**
 * 正規表現パターンオブジェクトを生成するためのファクトリクラスです
 * @author koseki
 *
 */
public class RegexPatternFactory {
	
	public static <T> int getRegexFlg(final Class<T> cls) throws RegexPatternException {
		if(isValidClass(cls)) {
			return CacheManager.getRegexCache().getRegexFlg(cls);			
		} else {
			String message = StringUtil.format("クラス[{}]は妥当なRegexBeanではありません", cls.getCanonicalName());
			throw new RegexPatternException(message);
		}
	}
	
	public static <T> Pattern createPattern(final Class<T> cls) throws RegexPatternException {
		if(isValidClass(cls)) {
			Regex regex = cls.getAnnotation(Regex.class);
			if(regex.useCache()) {
				return CacheManager.getRegexCache().createPattern(cls);
			} else {
				// useCache == falseの場合、キャッシュを行わない
				return NoCachedRegexCache.getInstance().createPattern(cls);
			}
		} else {
			String message = StringUtil.format("クラス[{}]は妥当なRegexBeanではありません", cls.getCanonicalName());
			throw new RegexPatternException(message);
			
		}
		
	}
	
	private static boolean isValidClass(Class<?> cls) {
		if (cls == null) {
			return false;
		}
		if (!cls.isAnnotationPresent(Regex.class)) {
			return false;
		}
		return true;
	}
}
