/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.dynamic.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.dyndns.nuda.dynamic.compiler.JavaClassObject;
import org.dyndns.nuda.tools.util.StringUtil;

public class ClassFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private static Method DEFINE_CLASS_METHOD = null;
    private static String DEFINE_CLASS_METHOD_NAME = "defineClass";
    private static Class<?>[] DEFINE_CLASS_METHOD_SIGNITURE = new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE};
    private static final Map<String, JavaClassObject> map = new HashMap<String, JavaClassObject>();
    protected static ClassLoader loader = null;

    public ClassFileManager(JavaCompiler compiler, DiagnosticListener<? super JavaFileObject> listener) {
        super(compiler.getStandardFileManager(listener, null, null));
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject libling) throws IOException {
        JavaClassObject co = new JavaClassObject(className, kind);
        map.put(className, co);
        return co;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        if (loader == null) {
            String message = StringUtil.format("class[{}] is not defiend cause DynamicClassLoader is null.", className);
            throw new ClassNotFoundException(message);
        }
        return loader.loadClass(className);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (loader == null) {
            loader = new Loader(Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
        }
        return loader;
    }

    public boolean exists(String className) {
        String basePath = System.getProperty("app.class.path");
        basePath = String.valueOf(basePath) + "\\";
        String nativeClassPathName = className.replace(".", "\\");
        basePath = String.valueOf(basePath) + nativeClassPathName + JavaFileObject.Kind.CLASS.extension;
        File classFile = new File(basePath);
        return classFile.exists();
    }

    private class Loader
    extends SecureClassLoader {
        public Loader(ClassLoader loader) {
            super(loader);
            if (DEFINE_CLASS_METHOD == null) {
                try {
                    Class<ClassLoader> loaderClass = ClassLoader.class;
                    DEFINE_CLASS_METHOD = loaderClass.getDeclaredMethod(DEFINE_CLASS_METHOD_NAME, DEFINE_CLASS_METHOD_SIGNITURE);
                    DEFINE_CLASS_METHOD.setAccessible(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            System.out.println("findClass:" + name);
            JavaClassObject co = (JavaClassObject)map.get(name);
            Class c = null;
            if (co == null) {
                if (ClassFileManager.this.exists(name)) {
                    byte[] b = null;
                    String basePath = System.getProperty("app.class.path");
                    basePath = String.valueOf(basePath) + "\\";
                    String nativeClassPathName = name.replace(".", "\\");
                    basePath = String.valueOf(basePath) + nativeClassPathName + JavaFileObject.Kind.CLASS.extension;
                    File classFile = new File(basePath);
                    int len = (int)classFile.length();
                    b = new byte[len];
                    try {
                        FileInputStream in = new FileInputStream(classFile);
                        DataInputStream dis = new DataInputStream(in);
                        dis.read(b);
                    }
                    catch (FileNotFoundException e) {
                        throw new ClassNotFoundException("\u6307\u5b9a\u3055\u308c\u305f\u30af\u30e9\u30b9\u540d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f", e);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("I/O\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
                    }
                    try {
                        c = (Class)DEFINE_CLASS_METHOD.invoke((Object)this.getParent(), name, b, 0, b.length);
                    }
                    catch (SecurityException e) {
                        throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u9055\u53cd\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1001)", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1002)", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1003)", e);
                    }
                    co = new JavaClassObject(name, JavaFileObject.Kind.CLASS);
                    map.put(name, co);
                    co.setDefinedClass(c);
                    return c;
                }
                return super.findClass(name);
            }
            c = co.getDefinedClass();
            if (c == null) {
                byte[] b = co.getBytes();
                try {
                    c = (Class)DEFINE_CLASS_METHOD.invoke((Object)this.getParent(), name, b, 0, b.length);
                }
                catch (SecurityException e) {
                    throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u9055\u53cd\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1001)", e);
                }
                catch (IllegalAccessException e) {
                    throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1002)", e);
                }
                catch (InvocationTargetException e) {
                    throw new ClassNotFoundException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u30a8\u30e9\u30fc\uff1a\u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f(SYS_ERR_C1003)", e);
                }
                co.setDefinedClass(c);
                this.outputFileSystem(c, b);
            }
            return c;
        }

        private void outputFileSystem(Class<?> cls, byte[] classBinaly) {
            String rootPath = System.getProperty("app.class.path");
            String subPath = cls.getName().replace(cls.getSimpleName(), "").replace(".", "\\");
            File rootDir = new File(String.valueOf(rootPath) + "\\" + subPath);
            boolean makeFlg = rootDir.mkdirs();
            if (makeFlg || rootDir.exists()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    boolean deleteFlg;
                    File outputClassFile = new File(String.valueOf(rootPath) + "\\" + subPath + "\\" + cls.getSimpleName() + JavaFileObject.Kind.CLASS.extension);
                    System.out.println("outputFileSystem:" + cls.getCanonicalName() + " -> " + rootPath + "\\" + subPath + "\\" + cls.getSimpleName() + JavaFileObject.Kind.CLASS.extension);
                    if (outputClassFile.exists() && !(deleteFlg = outputClassFile.delete())) {
                        System.out.println("\u53e4\u3044\u30af\u30e9\u30b9\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
                    }
                    FileOutputStream fos = new FileOutputStream(outputClassFile);
                    baos.write(classBinaly);
                    baos.writeTo(fos);
                    fos.close();
                    baos.reset();
                    baos.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff1a" + rootDir.exists());
            }
        }
    }
}

