/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.logger;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.tools.util.StringUtil;

public class JDKLoggerAdaptor
implements LoggerAdaptor {
    private Class<?> loggerClass = null;
    Object loggerObj = null;
    private Method getLogger = null;

    public JDKLoggerAdaptor() {
        String clsName = this.getLoggerClassName();
        try {
            this.loggerClass = Class.forName(clsName);
            this.getLogger = this.loggerClass.getDeclaredMethod("getLogger", String.class);
            this.loggerObj = this.getLogger.invoke(null, "org.dyndns.nuda.tools.util");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRecommendVersion() {
        return "1.6.x";
    }

    @Override
    public String getLoggerClassName() {
        return "java.util.logging.Logger";
    }

    @Override
    public Class<?> getLoggerClass() {
        try {
            Class<?> cls = Class.forName("java.util.logging.Logger");
            return cls;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public LoggerAdaptor getLogger(String loggerName) {
        Object backup = this.loggerObj;
        try {
            this.loggerObj = this.getLogger.invoke(null, loggerName);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.loggerObj = backup;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.loggerObj = backup;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.loggerObj = backup;
        }
        return this;
    }

    @Override
    public LoggerAdaptor getLogger(Class<?> targetClass) {
        String name = targetClass.getCanonicalName();
        return this.getLogger(name);
    }

    @Override
    public void trace(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("INFO");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("WARNING");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("WARNING");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("WARNING");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("WARNING");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String format, Object ... params) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("SEVERE");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class);
                String message = StringUtil.format(format, params);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.loggerClass != null) {
            try {
                Class<?> logLevel = Class.forName("java.util.logging.Level");
                Field info = logLevel.getDeclaredField("SEVERE");
                Object obj = info.get(null);
                Method m = this.loggerClass.getDeclaredMethod("logp", logLevel, String.class, String.class, String.class, Throwable.class);
                StackTraceElement[] steAry = Thread.currentThread().getStackTrace();
                StackTraceElement ste = steAry[2];
                m.invoke(this.loggerObj, obj, ste.getClassName(), ste.getMethodName(), message, t);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

