package org.lightdi.container.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ContainerConfig;

class DIContainerManager
{
	private Map<String, ContainerConfig> registeredConfigXMLList = new ConcurrentHashMap<String, ContainerConfig>();
	private Map<String, DIContainer> containerNameMapping = new ConcurrentHashMap<String, DIContainer>();
	private Map<String, ContainerConfig> containerConfigMapping = new ConcurrentHashMap<String, ContainerConfig>();

	public Map<String, ContainerConfig> getRegisterdConfigXMLList()
	{
		return registeredConfigXMLList;
	}

	public void setRegisterdConfigXMLList(
	        Map<String, ContainerConfig> registeredConfigXMLList)
	{
		this.registeredConfigXMLList = registeredConfigXMLList;
	}

	public Map<String, DIContainer> getContainers()
	{
		return containerNameMapping;
	}

	public void setContainers(Map<String, DIContainer> containers)
	{
		this.containerNameMapping = containers;
	}

	public boolean isRegistered(String configXML)
	{
		if (registeredConfigXMLList.get(configXML) != null)
			return true;
		else
			return false;
	}

	public DIContainer getContainerByName(String containerName)
	{
		return containerNameMapping.get(containerName);
	}

	public Map<String, ContainerConfig> getContainerConfigMapping()
	{
		return containerConfigMapping;
	}

	public void setContainerConfigMapping(
	        Map<String, ContainerConfig> containerConfigMapping)
	{
		this.containerConfigMapping = containerConfigMapping;
	}

}
