/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package org.lightdi;

import junit.framework.TestCase;

import org.lightdi.container.DIContainer;
import org.lightdi.container.factory.DIContainerFactory;

/**
 * Sample<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class Sample extends TestCase
{

	public void test_sample() throws Exception
	{
		// LightDIContainerFactory.addConfigXML("sample.xml");
		// LightDIContainerFactory.reloadContainers();

		DIContainer sampleContainer = DIContainerFactory.getContainer("sampleContainer");
		String helloWolrd = (String) sampleContainer.getComponent("helloWorld");
		System.out.println(helloWolrd);

		DIContainer dicon = DIContainerFactory.getContainer();
		SampleBean s0 = (SampleBean) dicon.getComponent("sample0");
		s0.print("s0");
		System.out.println(s0.getName());
		SampleBean s02 = (SampleBean) dicon.getComponent("sample0");
		s02.print("s02");
		System.out.println(s02.getName());
		assertEquals(s0, s02);
		SampleBean s1 = (SampleBean) dicon.getComponent("sample1");
		s1.print("s1");
		System.out.println(s1.getName());
		SampleBean s12 = (SampleBean) dicon.getComponent("sample1");
		s12.print("s12");
		assertTrue(s1 != s12);
		System.out.println(s12.getName());
		SampleBean s2 = (SampleBean) dicon.getComponent("sample2");
		s2.print("s2");
		System.out.println(s2.getName());
		SampleBean s22 = (SampleBean) dicon.getComponent("sample2");
		s22.print("s22");
		System.out.println(s22.getName());
		assertEquals(s2, s22);
		SampleBean s3 = (SampleBean) dicon.getComponent("sample3");
		s3.print("s3");
		System.out.println(s3.getName());

		DIContainer another = DIContainerFactory.getContainer("anotherContainer");
		SampleBean a0 = (SampleBean) another.getComponent("another0");
		a0.print("a0");
		System.out.println(a0.getName());
	}
}
