/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package org.lightdi.util;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * ArrayUtilTest<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class ArrayUtilTest extends TestCase
{

	public void test_toArray_typeParamIsObject() throws Exception
	{
		List<Object> arg = new ArrayList<Object>();
		arg.add(new Object());
		Object[] result = ArrayUtil.toArray(arg);
		assertEquals(arg.get(0), result[0]);
	}

	public void test_toArray_typeParamIsClass() throws Exception
	{
		List<Class<?>> arg = new ArrayList<Class<?>>();
		arg.add(String.class);
		Class<?>[] result = ArrayUtil.toArray(arg);
		assertEquals(arg.get(0), result[0]);
	}

}
