package org.lightdi.container;

import java.util.List;
import java.util.Map;

import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.security.ContainerLockKey;

public interface DIContainer {

	public static final String DEFAULT_CONTAINER_NAME = "lightdi-container";

	public List<MetaComponent> getMetaComponents();

	public void setMetaComponents(List<MetaComponent> metaComponents);

	public <T> Map<String, T> getSingletonComponents();

	public <T> void setSingletonComponents(Map<String, T> singletonComponents);

	public <T> T getComponent(String componentName);

	public <T> List<T> getComponents();

	public String getName();

	public void setName(String name);

	public void lock(ContainerLockKey key);

	public void unlock(ContainerLockKey key);

	public boolean isLocked();

}
