package org.lightdi.container.alias;

import org.lightdi.container.DIContainer;
import org.lightdi.container.factory.LightDIContainerFactory;

public class LightDI {

	public static DIContainer getDefaultContainer() {
		return LightDIContainerFactory.getDefaultContainer();
	}

	public static DIContainer getContainer(String name) {
		return LightDIContainerFactory.getContainer(name);
	}

	public static <T> T inject(String containerName, String componentName) {
		return LightDIContainerFactory.getContainer(containerName)
				.getComponent(componentName);
	}

	public static <T> T inject(String componentName) {
		return LightDIContainerFactory.getDefaultContainer().getComponent(
				componentName);
	}

}
