package org.lightdi.container.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.security.ContainerLockKey;

public final class ContainerConfig
{
	private boolean isLoaded = false;
	private String name;
	private ContainerLockKey lockKey;
	private String path;

	private Map<String, ComponentConfig> components = new ConcurrentHashMap<String, ComponentConfig>();

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getPath()
	{
		return path;
	}

	public void setPath(String path)
	{
		this.path = path;
	}

	public Map<String, ComponentConfig> getComponents()
	{
		return components;
	}

	public void setComponents(Map<String, ComponentConfig> components)
	{
		this.components = components;
	}

	public ComponentConfig getComponent(String componentName)
	{
		return components.get(componentName);
	}

	public boolean isLoaded()
	{
		return isLoaded;
	}

	public void setLoaded(boolean isLoaded)
	{
		this.isLoaded = isLoaded;
	}

	public ContainerLockKey getLockKey()
	{
		return lockKey;
	}

	public void setLockKey(ContainerLockKey lockKey)
	{
		this.lockKey = lockKey;
	}

}
