package org.lightdi.container.tag;

public final class ComponentTag
{
	private ComponentTag()
	{
	}

	public static final String ROOT = "component";

	public static final class Attributes
	{
		private Attributes()
		{
		}

		public static final String NAME = "name";
		public static final String CLASS = "class";
		public static final String VALUE = "value";
		public static final String INSTANCE_TYPE = "instance-type";
	}

	public static final class ArgTag
	{

		private ArgTag()
		{
		}

		public static final String ROOT = "arg";

		public static final class Attributes
		{
			private Attributes()
			{
			}

			public static final String VALUE = "value";
			public static final String CLASS = "class";
			public static final String REF = "ref";
		}
	}

	public static final class InitMethodTag
	{

		private InitMethodTag()
		{
		}

		public static final String ROOT = "init-method";

		public static final class Attributes
		{
			private Attributes()
			{
			}

			public static final String METHOD_NAME = "name";
		}
	}

	public static final class ConstructorArgTag
	{

		private ConstructorArgTag()
		{
		}

		public static final String ROOT = "constructor-arg";

		public static final class Attributes
		{
			private Attributes()
			{
			}

			public static final String VALUE = "value";
			public static final String CLASS = "class";
			public static final String REF = "ref";
		}
	}

	public static final class SetterArgTag
	{
		private SetterArgTag()
		{
		}

		public static final String ROOT = "setter-arg";

		public static final class Attributes
		{
			private Attributes()
			{
			}

			public static final String NAME = "name";
			public static final String VALUE = "value";
			public static final String CLASS = "class";
			public static final String REF = "ref";
		}
	}

}
